package org.wikibooks.en.wiki.WebObjects.Web_Services.How_to_Trust_Any_SSL_Certificate;

import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

/**
 * 
 * This class provide various static methods that relax X509 certificate and hostname verification while using the SSL over the HTTP protocol.
 * 
 * @author Kristian Martin inspired by Francis Labrie
 * @see <a href="http://en.wikibooks.org/wiki/WebObjects/Web_Services/How_to_Trust_Any_SSL_Certificate">Source: Article from Francis Labrie where</a>
 * @see <a href="http://java.sun.com/javase/6/docs/technotes/guides/security/jsse/JSSERefGuide.html">JavaTM Secure Socket Extension (JSSE) Reference Guide</a>
 */
public final class SSLUtilities
{

	/**
	 * Hostname verifier for the Sun's deprecated API.
	 * 
	 * @deprecated see {@link #_hostnameVerifier}.
	 */
	private static com.sun.net.ssl.HostnameVerifier __hostnameVerifier;
	/**
	 * Thrust managers for the Sun's deprecated API.
	 * 
	 * @deprecated see {@link #_trustManagers}.
	 */
	private static com.sun.net.ssl.TrustManager[] __trustManagers;
	/**
	 * Hostname verifier.
	 */
	private static HostnameVerifier _hostnameVerifier;
	/**
	 * Thrust managers.
	 */
	private static TrustManager[] _trustManagers;

	/**
	 * Set the default Hostname Verifier to an instance of a fake class that trust all hostnames. This method uses the old deprecated API from the com.sun.ssl package.
	 * 
	 * @deprecated see {@link #_trustAllHostnames()}.
	 */
	private static void __trustAllHostnamesDeprecated(URLConnection conn, boolean all)
	{
		// Create a trust manager that does not validate certificate chains
		if (__hostnameVerifier == null)
		{
			__hostnameVerifier = new _FakeHostnameVerifier();
		} // if
		// Install the all-trusting host name verifier
		if (all)
		{
			com.sun.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier(__hostnameVerifier);
		}
		else if (conn != null && conn instanceof com.sun.net.ssl.HttpsURLConnection)
		{
			((com.sun.net.ssl.HttpsURLConnection) conn).setHostnameVerifier(__hostnameVerifier);
		}
	} // __trustAllHttpsCertificates

	/**
	 * Set the default X509 Trust Manager to an instance of a fake class that trust all certificates, even the self-signed ones. This method uses the old deprecated API from the
	 * com.sun.ssl package.
	 * 
	 * @deprecated see {@link #_trustAllHttpsCertificates()}.
	 */
	private static void __trustAllHttpsCertificatesDeprecated(URLConnection conn, boolean all)
	{
		com.sun.net.ssl.SSLContext context;

		// Create a trust manager that does not validate certificate chains
		if (__trustManagers == null)
		{
			__trustManagers = new com.sun.net.ssl.TrustManager[] { new _FakeX509TrustManager() };
		} // if
		// Install the all-trusting trust manager
		try
		{
			context = com.sun.net.ssl.SSLContext.getInstance("SSL");
			context.init(null, __trustManagers, new SecureRandom());
		}
		catch (GeneralSecurityException gse)
		{
			throw new IllegalStateException(gse.getMessage());
		} // catch
		if (all)
		{
			com.sun.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
		}
		else if (conn != null && conn instanceof com.sun.net.ssl.HttpsURLConnection)
		{
			((com.sun.net.ssl.HttpsURLConnection) conn).setSSLSocketFactory(context.getSocketFactory());
		}

	} // __trustAllHttpsCertificates

	/**
	 * Return true if the protocol handler property java. protocol.handler.pkgs is set to the Sun's com.sun.net.ssl. internal.www.protocol deprecated one, false otherwise.
	 * 
	 * @return true if the protocol handler property is set to the Sun's deprecated one, false otherwise.
	 */
	private static boolean isDeprecatedSSLProtocol()
	{
		return ("com.sun.net.ssl.internal.www.protocol".equals(System.getProperty("java.protocol.handler.pkgs")));
	} // isDeprecatedSSLProtocol

	/**
	 * Set the default Hostname Verifier to an instance of a fake class that trust all hostnames.
	 */
	private static void _trustAllHostnames(URLConnection conn, boolean all)
	{
		// Create a trust manager that does not validate certificate chains
		if (_hostnameVerifier == null)
		{
			_hostnameVerifier = new FakeHostnameVerifier();
		} // if
		// Install the all-trusting host name verifier:
		if (all)
		{
			HttpsURLConnection.setDefaultHostnameVerifier(_hostnameVerifier);
		}
		else if (conn != null && conn instanceof HttpsURLConnection)
		{
			((HttpsURLConnection) conn).setHostnameVerifier(_hostnameVerifier);
		}

	} // _trustAllHttpsCertificates

	/**
	 * Set the default X509 Trust Manager to an instance of a fake class that trust all certificates, even the self-signed ones.
	 */
	private static void _trustAllHttpsCertificates(URLConnection conn, boolean all)
	{
		SSLContext context;

		// Create a trust manager that does not validate certificate chains
		if (_trustManagers == null)
		{
			_trustManagers = new TrustManager[] { new FakeX509TrustManager() };
		} // if
		// Install the all-trusting trust manager:
		try
		{
			context = SSLContext.getInstance("SSL");
			context.init(null, _trustManagers, new SecureRandom());
		}
		catch (GeneralSecurityException gse)
		{
			throw new IllegalStateException(gse.getMessage());
		} // catch
		if (all)
		{
			HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
		}
		else if (conn != null && conn instanceof HttpsURLConnection)
		{
			((HttpsURLConnection) conn).setSSLSocketFactory(context.getSocketFactory());
		}
	} // _trustAllHttpsCertificates

	/**
	 * Set the default Hostname Verifier to an instance of a fake class that trust all hostnames.
	 */
	public static void trustAllHostnames()
	{
		// Is the deprecated protocol setted?
		if (isDeprecatedSSLProtocol())
		{
			__trustAllHostnamesDeprecated(null, true);
		}
		else
		{
			_trustAllHostnames(null, true);
		} // else
	} // trustAllHostnames

	/**
	 * Set the default X509 Trust Manager to an instance of a fake class that trust all certificates, even the self-signed ones.
	 */
	public static void trustAllHttpsCertificates()
	{
		// Is the deprecated protocol setted?
		if (isDeprecatedSSLProtocol())
		{
			__trustAllHttpsCertificatesDeprecated(null, true);
		}
		else
		{
			_trustAllHttpsCertificates(null, true);
		} // else
	} // trustAllHttpsCertificates

	/**
	 * Set the Hostname Verifier for this connection to an instance of a fake class that trust all hostnames.
	 */
	public static void trustAllHostnames(URLConnection conn)
	{
		// Is the deprecated protocol setted?
		if (isDeprecatedSSLProtocol())
		{
			__trustAllHostnamesDeprecated(conn, true);
		}
		else
		{
			_trustAllHostnames(conn, true);
		} // else
	} // trustAllHostnames

	/**
	 * Set the default X509 Trust Manager to an instance of a fake class that trust all certificates, even the self-signed ones.
	 */
	public static void trustAllHttpsCertificates(URLConnection conn)
	{
		// Is the deprecated protocol setted?
		if (isDeprecatedSSLProtocol())
		{
			__trustAllHttpsCertificatesDeprecated(conn, true);
		}
		else
		{
			_trustAllHttpsCertificates(conn, true);
		} // else
	} // trustAllHttpsCertificates
} // SSLUtilities
