/*
 * Created on 27.07.2005
 *
 */
package de.j4ee.webloader.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Map.Entry;

import de.j4ee.util.Tracer;

/**
 * <br/>
 * There is no Warranty<br/>
 * 
 * @author Kristian Martin
 * 
 */
public class SimpleCookieHolder implements CookieHolder
{
	private TreeMap<String, Cookie> cookies = new TreeMap<String, Cookie>();
	private String unifier = null;
	public boolean trace = false;
	private static HashSet<String> reservedAttributeKeyNames = new HashSet<String>();
	static
	{
		reservedAttributeKeyNames.add("Version".toUpperCase());
		reservedAttributeKeyNames.add("Expires".toUpperCase());
		reservedAttributeKeyNames.add("Max-age".toUpperCase());
		reservedAttributeKeyNames.add("Domain".toUpperCase());
		reservedAttributeKeyNames.add("Path".toUpperCase());
		reservedAttributeKeyNames.add("Port".toUpperCase());
		reservedAttributeKeyNames.add("Comment".toUpperCase());
		reservedAttributeKeyNames.add("CommentURL".toUpperCase());
		reservedAttributeKeyNames.add("Secure".toUpperCase());
		reservedAttributeKeyNames.add("HTTPOnly".toUpperCase());
		reservedAttributeKeyNames.add("Discard".toUpperCase());
	}

	public SimpleCookieHolder()
	{
		this(null);
	}

	public SimpleCookieHolder(String name)
	{
		this.unifier += System.currentTimeMillis() + "_" + name;
	}

	/**
	 * 
	 */
	public void addCookie(String line, URL sourceURL)
	{
		Cookie newCookie = new Cookie(line, sourceURL);
		String value = newCookie.toString();
		CookieMatch matchedCookie = getCookie(newCookie.key, sourceURL);
		Cookie knownCookie = matchedCookie != null ? matchedCookie.cookie : null;
		if (knownCookie != null && matchedCookie.match >= CookieMatch.SAME_URL)
		{
			String mapKey = generateCookieMapKey(knownCookie.key, knownCookie.domain);
			if (newCookie.value == null || newCookie.value.trim().length() == 0 || "\"\"".equals(newCookie.value))
			{
				Tracer.trace("#Delete Cookie: " + knownCookie + " -> " + value, trace);
				cookies.remove(mapKey);
			}
			else if (newCookie.value.equals(knownCookie.value))
			{
				Tracer.trace("#Known Cookie: " + value, trace);
			}
			else if (!newCookie.value.equals(knownCookie.value))
			{
				Tracer.trace("#Updated Cookie: " + knownCookie + " -> " + value, trace);
				cookies.put(mapKey, newCookie);
			}
		}
		else if (newCookie.value != null && newCookie.value.length() > 0 && !"\"\"".equals(newCookie.value))
		{
			String mapKey = generateCookieMapKey(newCookie.key, newCookie.domain);
			Tracer.trace("#New Cookie: " + value + "", trace);
			cookies.put(mapKey, newCookie);
		}
	}

	public void clear()
	{
		cookies.clear();
	}

	/**
	 * @param matchingURL URL to be matched or null for all
	 */
	public String getCookies(URL matchingURL)
	{
		StringBuffer sb = null;
		if (cookies.size() > 0)
		{
			sb = new StringBuffer();
			Iterator<Entry<String, Cookie>> it = cookies.entrySet().iterator();
			while (it.hasNext())
			{
				Entry<String, SimpleCookieHolder.Cookie> entry = it.next();
				Cookie cookie = entry.getValue();
				// check url-Match
				if (cookie.matches(matchingURL) > -1)
				{
					// reminder: not checking using iterator.next() as its elements may not
					// match --> Lazy check
					if (sb.length() > 0)
						sb.append("; ");
					sb.append(cookie.key).append("=").append(cookie.value);
				}
			}
			if (sb.length() > 0)
				Tracer.trace("#Matching cookies (" + sb.length() + " bytes) for " + (matchingURL != null ? matchingURL.getHost() : null) + ": " + sb, trace);
			else
				Tracer.trace("#No Matching cookies for " + (matchingURL != null ? matchingURL.getHost() : null) + "!", trace);
			return sb.toString();
		}
		else
			Tracer.trace("#No cookies available to check match!", trace);
		return null;
	}

	private CookieMatch getCookie(String key, URL url)
	{
		String mapKey = generateCookieMapKey(key, url != null ? url.getHost() : null);
		Cookie cookie = cookies.get(mapKey);
		if (cookie == null)
		{
			// search first matching key
			Iterator<Entry<String, Cookie>> it = cookies.entrySet().iterator();
			while (it.hasNext())
			{
				Entry<String, SimpleCookieHolder.Cookie> entry = it.next();
				cookie = entry.getValue();
				int match = -1;
				if (cookie.key.equalsIgnoreCase(key) && (match = cookie.matches(url)) > -1)
				{
					return new CookieMatch(cookie, match);
				}
			}
		}
		else
		{
			return new CookieMatch(cookie, cookie.matches(url));
		}
		return null;
	}

	public String getCookieValue(String key, URL url)
	{
		CookieMatch matchedCookie = getCookie(key, url);
		Cookie cookie = matchedCookie != null ? matchedCookie.cookie : null;
		return (cookie != null ? cookie.value : null);
	}

	private String generateCookieMapKey(String cookieKey, String domain)
	{
		if (domain != null)
			return cookieKey + "[@" + domain + "]";
		return cookieKey;
	}

	public String getUnifier()
	{
		return unifier;
	}

	public String toString()
	{
		return getCookies(null);
	}

	class CookieMatch
	{
		public final static int NO_URL_REQUESTED = 0;
		public final static int NO_URL_STORED = 1;
		public final static int SAME_URL = 2;
		public final static int SAME_DOMAIN = 3;
		private int match = -1;
		private Cookie cookie = null;

		private CookieMatch(Cookie cookie, int match)
		{
			this.match = match;
			this.cookie = cookie;
		}
	}

	class Cookie
	{
		private URL sourceURL = null;
		private String domain = null;
		// private boolean secure = false;
		// NOT YET USED:private String path = null;
		private String value = null;
		private String key = null;
		private HashMap<String, String> attributes = new HashMap<String, String>();

		public Cookie(String line, URL sourceURL)
		{
			this.sourceURL = sourceURL;
			domain = (sourceURL != null ? sourceURL.getHost() : null);// default
			StringTokenizer tokenizer = new StringTokenizer(line, ";");
			while (tokenizer.hasMoreTokens())
			{
				String tokenKey = tokenizer.nextToken().trim();
				String tokenValue = null;
				int index = tokenKey.indexOf("=");
				if (index > -1)
				{
					tokenValue = tokenKey.substring(index + 1).trim();
					tokenKey = tokenKey.substring(0, index).trim();
				}
				if (reservedAttributeKeyNames.contains(tokenKey.toUpperCase()))
				{
					// isAttribute
					attributes.put(tokenKey.toUpperCase(), tokenValue);
					if ("DOMAIN".equalsIgnoreCase(tokenKey) && tokenValue.length() > 0)
					{
						domain = tokenValue.toUpperCase();
					}
				}
				else
				{
					if (tokenValue != null && tokenValue.length() > 0)
					{
						this.value = tokenValue;
					}
					this.key = tokenKey;
				}
			}
		}

		public String toString()
		{
			String ret = null;
			if (key != null)
			{
				ret = key + "=" + value;
				Iterator<String> it = attributes.keySet().iterator();
				while (it.hasNext())
				{
					String attrKey = it.next();
					String attrValue = attributes.get(attrKey);
					ret += "; " + attrKey;
					if (attrValue != null)
					{
						ret += "=" + attrValue;
					}
				}
			}
			return ret;
		}

		/**
		 * 
		 * @param url
		 * @return CookieMatch
		 */
		public int matches(URL url)
		{
			int ret = -1;
			if (url == null || url.getHost() == null)
				// case: get all
				ret = CookieMatch.NO_URL_REQUESTED;
			else if (sourceURL == null)
				// case: manual set
				ret = CookieMatch.NO_URL_STORED;
			else if (url.getHost().equalsIgnoreCase(sourceURL.getHost()))
				// case: same source
				ret = CookieMatch.SAME_URL;
			else if (url.getHost().toUpperCase().endsWith(domain.toUpperCase()))
				// case: same domain
				ret = CookieMatch.SAME_DOMAIN;
			// if (ret && "HTTPS".equalsIgnoreCase(url.getProtocol()) &&
			// !secure)
			// {
			// ret=false;
			// }
			return ret;
		}
	}

	public void retrieveCookies(URLConnection conn)
	{
		boolean done = false;
		int n = 1;
		while (!done)
		{
			String headerKey = conn.getHeaderFieldKey(n);
			String headerVal = conn.getHeaderField(n);
			if (headerKey != null || headerVal != null)
			{
				if (headerKey.toUpperCase().indexOf("COOKIE") > -1)
				{
					addCookie(headerVal, conn.getURL());
				}
			}
			else
			{
				done = true;
			}
			n++;
		}
	}

}
