package de.j4ee.webloader.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxyAuthenticator
{

	/**
	 * Instanciates Authenticator using User and Password stored in System.properties; recognizes http.- and https.- prefix as well
	 */
	public static void useSystemProperties()
	{
		String[] prefixes = new String[] { "", "http", "https" };
		String user = getProp(prefixes, "proxyUser");
		String pass = getProp(prefixes, "proxyPassword");
		set(user, pass);
	}

	public static void use(String user, String password)
	{
		set(user,password);
	}
	
	private static String getProp(String[] prefixes, String key)
	{
		String ret = null;
		for (int a = 0; a < prefixes.length; ++a)
		{
			if (prefixes[a] != null && prefixes[a].length() > 0)
				ret = System.getProperty(prefixes[a] + "." + key, ret);
			else
				ret = System.getProperty(key, ret);
		}
		return ret;
	}

	private static void set(final String username, final String pass)
	{
		Authenticator auth = new Authenticator()
		{
			protected PasswordAuthentication getPasswordAuthentication()
			{
				return new PasswordAuthentication(username, pass.toCharArray());
			}
		};
		Authenticator.setDefault(auth);
	}
}
