package de.j4ee.webloader.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import de.j4ee.util.Tracer;

/**
 * This class provides mechanism to call back the server to submit basic data about the function of the applet on clientside. <br/>
 * There is no Warranty<br/>
 * 
 * @author Kristian Martin
 * @version 1.0
 */
public class Networker
{
	public String AGENT = "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.17) Gecko/20110420 Firefox/3.6.17 ( .NET CLR 3.5.30729; .NET4.0C)";//+" via WebLoader"; //$NON-NLS-1$
	public Integer TIMEOUT = 60000;
	private NetResult nr = new NetResult();
	public boolean trace = false;
	/**
	 * If Outputstream is set, the output would be streamed there (line based)
	 */
	public OutputStream outputStream = null;
	/**
	 * If set to true the output of the request would be only streamed to defined outputstream (Redirected)
	 */
	public boolean streamOnly = false;
	public boolean fillRefererWithPreviousUsedUrl = true;
	public final static int FOLLOWMODE_NOFOLLOW = 0;
	public final static int FOLLOWMODE_HIDDEN = 1;
	public final static int FOLLOWMODE_DETAILED = 2;
	public final static String PLAIN_BODY_KEY = "<BODY>";

	/**
	 * Constructor
	 */
	public Networker(boolean ssl)
	{
		if (ssl)
		{
			SSLManager.activate();
		}
	}

	/**
	 * Retrieves NetResult
	 * 
	 * @return netresult
	 */
	public NetResult getNetResult()
	{
		return nr;
	}

	/**
	 * @param si
	 * @param referer
	 * @return
	 * @throws MalformedURLException
	 */
	private String follow(CookieHolder si, String referer)
	{
		String ret = null;
		String urlString = nr.getLocation();
		while (urlString != null)
		{
			Tracer.trace(" -}FOLLOW#" + (nr.round + 1) + ": " + urlString, trace);
			URL url = null;
			try
			{
				url = new URL(urlString);
			}
			catch (MalformedURLException e)
			{
				url = nr.getURL();
				try
				{
					url = new URL(new URL(url.getProtocol() + "://" + url.getHost()), urlString);
				}
				catch (MalformedURLException e1)
				{
					e1.printStackTrace();
				}
			}
			// On location-follow referer keeps origin URL ...as it seems so in FF...
			// String referer =
			nr.addRound(url).toString();
			ret = send(url, null, si, null, 0, referer);
			urlString = nr.getLocation();
		}
		return ret;
	}

	/**
	 * Resolves relative paths containing ..
	 * 
	 * @param url
	 * @return
	 * @throws MalformedURLException
	 */
	private URL resolveRelativeURL(URL url) throws MalformedURLException
	{
		String ext = url.toExternalForm();
		int index = ext.indexOf("..");
		int index2 = ext.indexOf("?");// avoid correcting parameters
		if (index > -1 && index < index2)
		{
			URL tUrl = new URL(ext.substring(0, index));
			url = new URL(tUrl, ext.substring(index));
		}
		return url;
	}

	/**
	 * Sends data to URL
	 * 
	 * @param url destination-URL
	 * @param postprops Post-data as key-value-pairs or plain using &lt;BODY&gt;(PlainBodyKey) as key.
	 * @param si Cookieholder containg cookies to be send along
	 * @param requestProperties used to set requestProperties to the connection
	 * @return Result bodycontent
	 * @throws Exception
	 */
	public String send(URL url, Map postprops, CookieHolder si, Map requestProperties, int followMode)
	{
		URL refererUrl = nr.reset(url);
		String referer = null;
		if (fillRefererWithPreviousUsedUrl)
		{
			// REMINDER: referer will be automatically set to previous url !!!
			referer = refererUrl != null ? refererUrl.toString() : null;
		}
		return send(url, postprops, si, requestProperties, followMode, referer);
	}

	/**
	 * private Method containing additional refer
	 * 
	 * @param url
	 * @param postprops
	 * @param si
	 * @param requestProperties
	 * @param followMode
	 * @param referer
	 * @return
	 */
	private String send(URL url, Map postprops, CookieHolder si, Map requestProperties, int followMode, String referer)
	{
		String method = "GET";
		if (postprops != null && postprops.size() > 0)
		{
			method = "POST";
		}
		HttpURLConnection c = null;
		try
		{
			String body = getBody(postprops);
			Tracer.trace(" --->:" + "Send " + method + "-Request [" + followMode + "]" + " to " + url + " ...." + ("POST".equals(method)?("\n\tPost:" + body):""), trace);
			url = resolveRelativeURL(url);
			// START!!!
			nr.startTimer();
			c = (HttpURLConnection) getConnection(url, si);
			c.setUseCaches(false);
			c.setAllowUserInteraction(false);
			c.setInstanceFollowRedirects(followMode == FOLLOWMODE_HIDDEN);
			if (referer != null && c.getRequestProperty("Referer") == null)
			{
				c.setRequestProperty("Referer", referer); //$NON-NLS-1$
			}
			if (requestProperties != null)
			{
				setProperties(c, requestProperties);
			}
			if (("POST").equals(method))
			{
				c.setDoOutput(true); // Default is false so only set if required...
				c.setRequestMethod(method); // Default is GET, so only change if POST is required...
				c.setRequestProperty("Content-Length", String.valueOf(body.length())); //$NON-NLS-1$
				c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded"); //$NON-NLS-1$ //$NON-NLS-2$
				OutputStream rawOutStream = null;
				PrintWriter out = null;
				try
				{
					rawOutStream = c.getOutputStream();
					out = new PrintWriter(rawOutStream);
					out.print(body);
					out.flush();
					out.close();
				}
				finally
				{
					closeObjects(out, rawOutStream);
				}
			}
			nr.splitTimer();
			nr.setReturnContent(readStream(c.getInputStream(), false));
			nr.readHeader(c, si);
			// STOP!!!
		}
		catch (IOException e)
		{
			error(url, e, "RC:" + nr.getResponseCode() + " RM:" + nr.getResponseMessage());
			try
			{
				ByteArrayOutputStream errorContent = readStream(c.getErrorStream(), true);
				if (errorContent == null)
				{
					errorContent = new ByteArrayOutputStream();
					errorContent.write(e.toString().getBytes());
				}
				nr.setReturnContent(errorContent);
				{
					nr.readHeader(c, si);
				}
			}
			catch (IOException e1)
			{
				error(url, e1, "RC:" + nr.getResponseCode() + " RM:" + nr.getResponseMessage());
			}
			nr.setResponseMessageIfNoReply(e);
		}
		String rs = nr.getReturnState();
		Tracer.trace(rs, trace);
		if (followMode == FOLLOWMODE_DETAILED)
		{
			follow(si, referer);
		}
		return nr.getReturnContent();
	}

	/**
	 * Reads connection
	 * 
	 * @param conn Connection to be read
	 * @return String read
	 * @throws IOException
	 * @throws Exception
	 */
	private ByteArrayOutputStream readStream(InputStream is, boolean isErrorStream) throws IOException
	{
		long bytesAmount=0;
		ByteArrayOutputStream baos = null;
		BufferedInputStream bis = null;
		if (is != null)
		{
			try
			{
				bis = new BufferedInputStream(is);
				baos = new ByteArrayOutputStream();
				byte[] buffer = new byte[4096];
				int read = bis.read(buffer);
				while (read != -1)
				{
					bytesAmount+=read;
					if (!streamOnly || outputStream == null)
						baos.write(buffer, 0, read);
					if (outputStream != null)
					{
						outputStream.write(buffer, 0, read);
						outputStream.flush();
					}
					read = bis.read(buffer);
				}
			}
			catch (Throwable e)
			{
				error(nr.getURL(), e, "Data read:" + bytesAmount + " bytes");
			}
			finally
			{
				closeObjects(null, bis, is);
			}
		}
		Tracer.trace(bytesAmount + " bytes read", trace);
		return baos;
	}

	/**
	 * Externalized method to close Objects
	 * 
	 * @param pw Printwriter
	 * @param os OutputStream
	 */
	private void closeObjects(PrintWriter pw, OutputStream os)
	{
		if (pw != null)
		{
			pw.close();
		}
		if (os != null)
		{
			try
			{
				os.close();
			}
			catch (IOException e1)
			{
				// Nothing required here, as no business impact
			}
		}
	}

	/**
	 * Externalized method to close Objects
	 * 
	 * @param br BufferedReader
	 * @param isr InputStreamReader
	 * @param in InputStream
	 */
	private void closeObjects(Closeable br, Closeable isr, Closeable in)
	{
		if (br != null)
		{
			try
			{
				br.close();
			}
			catch (IOException e1)
			{
				// Nothing required here, as no business impact
			}
		}
		if (isr != null)
		{
			try
			{
				isr.close();
			}
			catch (IOException e1)
			{
				// Nothing required here, as no business impact
			}
		}
		if (in != null)
		{
			try
			{
				in.close();
			}
			catch (IOException e1)
			{
				// Nothing required here, as no business impact
			}
		}
	}

	/**
	 * Converts Properties to well-formed body
	 * 
	 * @param props Key-value pair of parameters
	 * @return wellformed-body
	 * @throws UnsupportedEncodingException
	 */
	private String getBody(Map props) throws UnsupportedEncodingException
	{
		StringBuffer sb = new StringBuffer();
		if (props != null)
		{
			if (props.get(PLAIN_BODY_KEY) == null)
			{
				Iterator<?> enumer = props.keySet().iterator();
				int a = 0;
				while (enumer.hasNext())
				{
					String key = (String) enumer.next();
					String value = (String) props.get(key);
					if (a > 0)
					{
						sb.append("&" + key + "=" + URLEncoder.encode(value, "UTF-8")); //$NON-NLS-1$ //$NON-NLS-2$
					}
					else
					{
						sb.append(key + "=" + URLEncoder.encode(value, "UTF-8")); //$NON-NLS-1$
					}
					a++;
				}
			}
			else
			{
				sb.append(props.get("<BODY>"));
			}
		}
		return sb.toString();
	}

	// private String getContent(Map props)
	// {
	// StringBuffer sb = new StringBuffer();
	// if (props != null)
	// {
	// Iterator enumer = props.keySet().iterator();
	// int a = 0;
	// while (enumer.hasNext())
	// {
	// String key = (String) enumer.next();
	// String value = "" + props.get(key);
	//				sb.append("" + key + "=" + URLEncoder.encode(value) + "\r\n"); //$NON-NLS-1$ //$NON-NLS-2$
	// a++;
	// }
	// }
	// return sb.toString();
	// }

	/**
	 * Opens connection
	 * 
	 * @param url Destination
	 * @return URLConnection
	 * @throws IOException
	 */
	private URLConnection getConnection(URL url, CookieHolder si) throws IOException
	{
		// verbindungsaufbau...
		HttpURLConnection conn = null;
		conn = (HttpURLConnection) url.openConnection();
		conn.setDoInput(true);// ChunkedStreamingMode(0);
		conn.setRequestProperty("User-Agent", AGENT); //$NON-NLS-1$
		conn.setUseCaches(false);
		String cookies = null;
		if (si != null && (cookies = si.getCookies(url)) != null && cookies.length() > 0)
		{
			conn.setRequestProperty("Cookie", cookies);
		}
		if (outputStream != null)
		{
			conn.setConnectTimeout(Integer.MAX_VALUE);
			conn.setReadTimeout(Integer.MAX_VALUE);
		}
		else
		{
			conn.setConnectTimeout(TIMEOUT);
			conn.setReadTimeout(TIMEOUT);
		}
		return conn;
	}

	/**
	 * Set Requestproperties of connection
	 * 
	 * @param conn
	 * @param requestProperties
	 */
	private void setProperties(URLConnection conn, Map<String, String> requestProperties)
	{
		Iterator<Entry<String, String>> it = requestProperties.entrySet().iterator();
		while (it.hasNext())
		{
			Entry<String, String> entry = it.next();
			conn.setRequestProperty((String) entry.getKey(), (String) entry.getValue());
		}
	}

	/**
	 * Log Throwable
	 * 
	 * @param error
	 */
	private void error(URL url, Throwable error, String comment)
	{
		{
			System.err.println("]:ERROR:[" + url + "]" + (comment != null ? ("{" + comment + "}") : "" + error));
			error.printStackTrace();
		}
	}

}