package de.j4ee.webloader.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import de.j4ee.util.Utools;
import de.j4ee.util.logger.Appender;
/**
 * <br/>
 * There is no Warranty<br/>
 * 
 * @author Kristian Martin
 * 
 */
public class NetResult
{
	private static final String RES_CODE = "Res_Code";
	private static final String RES_MESSAGE = "Res_Message";
	private ByteArrayOutputStream returnContent = null;
	private Map<String, List<String>> returnHeader = null;
	private int responseCode = -1;
	private String responseMessage = null;
	private URL url = null;
	private long start = -1;
	private long stop = -1;
	private long split = -1;
	int round = 0;
	private ArrayList<Result> states = new ArrayList<Result>();

	/**
	 * 
	 * @param urlNew
	 * @return last url read
	 */
	URL reset(URL urlNew)
	{
		round = 0;
		states = new ArrayList<Result>();
		return coreReset(urlNew);
	}

	/**
	 * 
	 * @param urlNew
	 * @return last url read
	 */
	private URL coreReset(URL urlNew)
	{
		start = System.currentTimeMillis();
		stop = -1;
		split = -1;
		returnContent = null;
		returnHeader = null;
		responseCode = -1;
		URL tURL = url;// (url != null ? url : urlNew);
		this.url = urlNew;
		return tURL;
	}

	void startTimer()
	{
		start = System.currentTimeMillis();
	}

	void stopTimer()
	{
		stop = System.currentTimeMillis();
	}

	void splitTimer()
	{
		split = System.currentTimeMillis();
	}

	URL addRound(URL urlNew)
	{
		if (round >= 10)
			throw new IllegalStateException("Follow-count reached max rounds: " + round + " (InfiniteLoop assumed).");
		round++;
		return coreReset(urlNew);
	}

	public URL getURL()
	{
		return url;
	}

	void readHeader(URLConnection conn, CookieHolder si) throws IOException
	{
		responseCode = ((HttpURLConnection) conn).getResponseCode();
		responseMessage = ((HttpURLConnection) conn).getResponseMessage();
		returnHeader = conn.getHeaderFields();
		stopTimer();
		if (si != null)
			si.retrieveCookies(conn);
		else
			System.err.println("No cookieholder defined !");
	}

	/*
	 * Location
	 */
	public String getLocation()
	{
		return getHeaderField("Location");
	}

	public String getHeaderField(String key)
	{
		String value = null;
		if (RES_MESSAGE.equalsIgnoreCase(key))
		{
			return getResponseMessage();
		}
		else if (RES_CODE.equalsIgnoreCase(key))
		{
			return "" + getResponseCode();
		}
		else if (returnHeader != null)
		{
			List<String> l = returnHeader.get(key);
			if (l != null && l.size() > 0)
			{
				value = "" + l.get(0);
			}
		}
		return value;
	}

	public String dumpReturnHeader()
	{
		String ret = "Header:\n";
		Iterator<Map.Entry<String, List<String>>> entries = returnHeader.entrySet().iterator();
		while (entries.hasNext())
		{
			Map.Entry<String, List<String>> entry = entries.next();
			ret += ("\t" + entry.getKey() + "=" + entry.getValue() + "\n");
		}
		return ret;
	}

	void setReturnContent(ByteArrayOutputStream content)
	{
		stop = System.currentTimeMillis();
		this.returnContent = content;
	}

	/**
	 * Get received content as ByteArrayOutputStream being compatible with binary data.
	 * 
	 * @return Received content as ByteArrayOutputStream
	 */
	public ByteArrayOutputStream getReturnContentAsBaos()
	{
		return returnContent;
	}

	/**
	 * Returns received content
	 * 
	 * @return Received content as string
	 */
	public String getReturnContent()
	{
		if (returnContent != null)
			return returnContent.toString();
		else
			return null;
	}

	public int getResponseCode()
	{
		return responseCode;
	}

	public String getResponseMessage()
	{
		return responseMessage;
	}

	public void setResponseMessageIfNoReply(Throwable t)
	{
		if (responseMessage == null && responseCode == -1)
			responseMessage = "" + t;
	}

	public ArrayList<Result> getReturnStates()
	{
		return states;
	}

	/**
	 * Aggregates states and returns compressed result
	 * 
	 * @return aggregatedReturnStates
	 */
	public String getAggregatedReturnStates()
	{
		Result result = new Result((Result) states.get(states.size() - 1));
		result.url = ((Result) states.get(0)).url;
		result.xlsStartTime = ((Result) states.get(0)).xlsStartTime;
		for (int a = 0; a < states.size() - 1; ++a)
		{
			result.duration += ((Result) states.get(a)).duration;
			result.length += ((Result) states.get(a)).length;
		}
		return result.toString();
	}

	/**
	 * Returns current Result as String Generates current one if required
	 * 
	 * @return ReturnState
	 */
	public String getReturnState()
	{
		Result rs = new Result();
		rs.url = this.url;
		if (states.size() == round)
		{
			rs.xlsStartTime = Utools.getDateInExcelFormat(start);
			rs.startTime = start;
			rs.duration = (stop - start);
			rs.sendDuration = (split - start);
			rs.state = getResponseCode() + ":" + getResponseMessage();
			rs.location = getLocation();
			String returnContent = getReturnContent();
			if (returnContent != null && (rs.length = returnContent.length()) > 0)
			{
				int start = returnContent.indexOf("title>");
				int stop = returnContent.indexOf("</title", start);
				if (start > -1 && stop > start)
				{
					rs.title = returnContent.substring(start + 6, stop).trim();
				}
			}
			states.add(rs);
		}
		else
		{
			rs = (Result) states.get(round);
		}
		return "" + rs;
	}

	public static class Result
	{
		private static final String CSV_SEP = Appender.CSV_SEP;
		public String xlsStartTime = "";
		public long startTime = -1;
		public long duration = -1;
		public long sendDuration = -1;
		public String title = null;
		public String state = null;
		public String location = null;
		public int length = -1;
		public URL url = null;

		Result()
		{
		}

		Result(Result res)
		{
			this.xlsStartTime = res.xlsStartTime;
			this.startTime = res.startTime;
			this.duration = res.duration;
			this.sendDuration = res.sendDuration;
			this.title = res.title;
			this.state = res.state;
			this.location = res.location;
			this.length = res.length;
			this.url = res.url;
		}

		public String toString()
		{
			return CSV_SEP + startTime + CSV_SEP + xlsStartTime + CSV_SEP + sendDuration + CSV_SEP + state + CSV_SEP + title + CSV_SEP + location + CSV_SEP + length + CSV_SEP
					+ (duration) + "";
		}

		/**
		 * Static method to get header values used in toString() which contains concrete values
		 * 
		 * @return Header-Line
		 */
		public static String getToStringHeader()
		{
			return CSV_SEP + "StartTimeInMs" + CSV_SEP + "StartTimeInXls" + CSV_SEP + "SendDuration" + CSV_SEP + "ReturnState" + CSV_SEP + "PageTitle" + CSV_SEP + "LocationField"
					+ CSV_SEP + "BodySize" + CSV_SEP + ("CompleteDuration") + "";
		}
	}
}
