package de.j4ee.webloader.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
/**
 * This class can be used for read data in streaming mode, e.g.:<br/>
 * ListenerStream stream = new ListenerStream();<br/>
 * stream.addListener(stream.new StreamListener(){});<br/>
 * ...<br/>
 * nw.outputStream = stream;<br/>
 * ...<br/>
 * There is no Warranty <br/>
 * 
 * @author Kristian Martin
 * 
 */
public class ListenerStream extends OutputStream
{
	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	ArrayList<StreamListener> listeners = new ArrayList<StreamListener>();
	int previousSize = 0;

	@Override
	public void write(int b) throws IOException
	{
		baos.write(b);
	}

	@Override
	public void flush() throws IOException
	{
		int currentSize = baos.size();
		String temp = new String(baos.toByteArray(), previousSize, currentSize - previousSize);
		for (int a = 0; a < listeners.size(); ++a)
		{
			listeners.get(a).notify(temp);
		}
		previousSize = currentSize;
		//After flush, the stream can be recreated (reseted)
		{
			baos = new ByteArrayOutputStream();
			previousSize=0;
		}
	}

	@Override
	public void close() throws IOException
	{
		baos.close();
	}

	public void addListener(StreamListener listener)
	{
		listeners.add(listener);
	}

	public abstract class StreamListener
	{
		public abstract void notify(String text);
	}

}
