package de.j4ee.webloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

import de.j4ee.util.CommonUtil;
import de.j4ee.util.ListReader;
import de.j4ee.util.logger.Appender;
/**
 * @author Kristian Martin
 *
 *	There is no Warranty
 */
class WebLoader
{
	private Appender logger = null;
	private final String COMMAND_WAIT="WAIT";
	@Deprecated
	private final String COMMAND_USE="USE";
	private final String COMMAND_START="START";
	private final String COMMAND_CALL="CALL";

	WebLoader(String loaderFile) throws Throwable
	{
		logger = new Appender(loaderFile + ".log");
		go(loaderFile);
	}
	
	private void go(String filename) throws Throwable
	{
		ThreadGroup tg=new ThreadGroup("WebLoader");
		File file = new File(filename);
		logger.log(Appender.TYPE_TRACE,"READ COMMANDS FROM:" + file.getAbsolutePath());
		BufferedReader br = new BufferedReader(new FileReader(file));
		String line = br.readLine();
		long start = System.currentTimeMillis();
		while (line != null)
		{
			if (!line.startsWith("#") && line.length() > 0)
			{
				logger.log(Appender.TYPE_TRACE,"Process:" + line);
				if (line.startsWith(COMMAND_WAIT))
				{
					int commaIndex=line.indexOf(",");
					Thread.sleep(new Long(line.substring(commaIndex+1).trim()).longValue());
				}
				else if (line.startsWith(COMMAND_USE)||line.startsWith(COMMAND_START))
				{
					ClientThreader loader=new ClientThreader(logger,line);
					loader.run();
				}
				else if (line.startsWith(COMMAND_CALL))
				{
					ClientThreader loader=new ClientThreader(logger,line);
					Thread loaderThread=new Thread(tg,loader);
					loaderThread.start();
				}
			}
			line = br.readLine();
		}
		while (tg.activeCount() > 0)
		{
			tg.wait(100);
		}
		long stop = System.currentTimeMillis();
		logger.log(Appender.TYPE_TRACE,"FINISHED WEBLOADER (took " + (stop - start) + " millis");
	}

	public static void main(String[] args) throws Throwable
	{
		System.err.println(WebLoader.class.getSimpleName()+" {V "+CommonUtil.getLM(WebLoader.class)+"}");
		if (args==null||args.length!=1)
		{
			ArrayList<String> lines=ListReader.readAsIs("./webloader_usage.txt");
			for (int a=0;a<lines.size();++a)
			{
				System.err.println(lines.get(a));
			}
		}
		else
		{
			new WebLoader(args[0]);
		}
	}
}
