package de.j4ee.webloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/**
 * 
 * @author Kristian Martin
 * 
 */
class WebCommandList
{
	File source = null;
	ArrayList<Command> cmds = new ArrayList<Command>();
	HashMap<String, Integer> hm = new HashMap<String, Integer>(); // required for goto tasks....

	WebCommandList(WebClient wc, File file) throws IOException
	{
		readCommands(wc, file);
	}

	WebCommandList(WebClient wc, File parentFile, String filename) throws IOException
	{
		readCommands(wc, new File(parentFile!=null?parentFile.getParentFile():null, filename));
	}

	void merge(WebCommandList cmdList, int index)
	{
		cmds.remove(index);
		cmds.addAll(index, cmdList.cmds);
		generateHashMap();
	}

	private void generateHashMap()
	{
		hm.clear();
		for (int a = 0; a < cmds.size(); ++a)
		{
			Command command = (Command) (cmds.get(a));
			if (!hm.containsKey(command.task))
			{
				hm.put(command.task, new Integer(a));
			}
		}
	}

	private void readCommands(WebClient wc, File source) throws IOException
	{
		HashSet<String> tasks = new HashSet<String>();
		wc.tracer("READ COMMANDS FROM:" + source.getAbsolutePath());
		cmds = new ArrayList<Command>();
		if (source.exists())
		{
			BufferedReader br = new BufferedReader(new FileReader(source));
			String line = br.readLine();
			String task = null;
			int id = -1;
			while (line != null)
			{
				line = line.trim();
				if (line.startsWith("["))
				{
					task = line;
					if (!tasks.contains(task))
					{
						tasks.add(task);
						id++;
						Command cmd = new Command(line, task, id);
						cmds.add(cmd);
					}
					else
						wc.tracer("Duplicate Task '" + task + "' found !!");
					id = -1;
				}
				else if (line.startsWith("*["))
				{
					task = "OFF";
					id = -1;
				}
				else if (!line.startsWith("#") && line.length() > 0 && !"OFF".equals(task))
				{
					id++;
					Command cmd = new Command(line, task, id);
					cmds.add(cmd);
				}
				line = br.readLine();
			}
			generateHashMap();
		}
		wc.tracer("READ " + cmds.size() + " COMMANDS in " + hm.size() + " TASKS");

	}

}
