package de.j4ee.webloader;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.j4ee.util.CommonUtil;
import de.j4ee.util.ListReader;
import de.j4ee.util.Parser;
import de.j4ee.util.Tracer;
import de.j4ee.util.Utools;
import de.j4ee.util.csv.CsvReader;
import de.j4ee.util.logger.Appender;
import de.j4ee.util.xml.XMLHelper;
import de.j4ee.webloader.extension.CommandprocessorInterface;
import de.j4ee.webloader.net.NetResult;
import de.j4ee.webloader.net.Networker;
import de.j4ee.webloader.net.ProxyAuthenticator;
import de.j4ee.webloader.net.SimpleCookieHolder;
import de.j4ee.webloader.net.NetResult.Result;
/**
 * 
 * @author Kristian Martin
 * 
 */

public class WebClient implements Runnable
{
	private String CSV_SEP = Appender.CSV_SEP;
	private final String CURRENT_RESPONSECODE_KEY = "$RC$";
	private final String CURRENT_RESPONSEMESSAGE_KEY = "$RM$";
	private final String CURRENT_RESULT_KEY = "$RET$";
	private final String TIMESTAMP_KEY = "$TIME$";
	private final String DATESTAMP_KEY = "$DATE$";
	private Random ran = new Random();
	private Networker nw = null;
	private SimpleCookieHolder si = new SimpleCookieHolder();
	private Parser p = new Parser();
	private HashMap<String, String> variables = new HashMap<String, String>();
	private String currentRet = null;
	private boolean trace = false;
	private final String header = (CSV_SEP + "THREAD" + CSV_SEP + "TASK" + CSV_SEP + "TASK_COMMAND# REDIRECTS" + CSV_SEP + "URL" + NetResult.Result.getToStringHeader());
	private Appender logger = new Appender(header);
	private Appender tracker = new Appender(header);
	private WebCommandList commands = null;
	private Sync sync = null;
	private CommandprocessorInterface ci = null;
	public final static int MODE_DEFAULT = 0; // No Tracker
	public final static int MODE_PERF = 1; // Aggregated Tracker
	public final static int MODE_PERF_DETAIL = 2; // Detailed Tracker
	private int mode = MODE_DEFAULT;

	private WebClient(boolean ssl)
	{
		nw = new Networker(ssl);
		tracer("USE SSL:" + ssl);
	}

	public WebClient(String filename) throws IOException
	{
		this(true);
		commands = new WebCommandList(this, new File(filename));
	}

	WebClient(File file, Sync sync) throws IOException
	{
		this(true);
		this.sync = sync;
		commands = new WebCommandList(this, file);
	}

	private void processCommands() throws Exception
	{
		this.processCommands(commands);
	}

	private void processCommands(WebCommandList commands) throws Exception
	{
		currentRet = null;
		for (int a = 0; a < commands.cmds.size(); ++a)
		{
			Command command = (Command) (commands.cmds.get(a));
			tracer("PROCESS:" + command);
			try
			{
				String cmd = command.cmd;
				CsvReader csvReader = new CsvReader(cmd, " ");
				String[] paras = csvReader.getLine();
				if (paras[0].startsWith("[") || paras[0].equalsIgnoreCase("REM"))
				{
					continue;// ignore
				}
				else if (Utools.isIn(paras[0], Command.EXIT_QUIT))
				{
					return;
				}
				else if (Command.EXT.equals(paras[0]))
				{
					tracer("Let " + ci + " process '" + cmd + "'");
					if (ci != null)
					{
						ci.process(paras);
					}
					else
					{
						error("No extension class defined to interpret/process command: " + cmd);
					}
				}
				else if (Utools.isIn(paras[0], Command.GOTO_GIVC))
				{
					boolean conditionfulfilled = true;
					String counter = "~";
					if (paras.length >= 3)
					{
						if (!"~".equals(paras[2]))
						{
							if (Utools.isInteger(paras[2]))
							{
								counter = "" + ((Integer.parseInt((paras[2]))) - 1);// decrement
								command.cmd = (paras[0] + " " + paras[1] + " " + counter); // adjust command
							}
							else
							// GIVC-case
							{
								String var = CURRENT_RESULT_KEY;
								String val = paras[2];
								if (paras.length == 4)
								{
									var = paras[2];
									val = paras[3];
								}
								conditionfulfilled = resolveVariables(var).contains(resolveVariables(val));
							}
						}
					}
					if ("~".equals(counter) || (Integer.parseInt(counter) >= 0))
					{
						String taskName = resolveVariables(paras[1]);
						if (!taskName.startsWith("["))
							taskName = "[" + taskName;
						// force goto task
						Integer taskId = commands.hm.get(taskName);
						if (taskId != null && conditionfulfilled)
						{
							a = new Integer("" + taskId).intValue() - 1;
							tracer("GOTO " + taskName + "(index:" + taskId + ")");
						}
						else
							tracer("NOT GOTO " + taskName + "(index:" + taskId + ")");
					}
					else
					{
						// skip
					}
					continue;
				}
				else if (Utools.isIn(paras[0], Command.RUN_CALL_START))
				{
					WebClient wc=new WebClient(resolveVariables(paras[1]));
					wc.getVariables().putAll(new HashMap<String, String>(getVariables()));
					wc.run();
				}
				else if (Command.INCLUDE.equals(paras[0]))
				{
					WebCommandList includeCommands = new WebCommandList(this, commands.source, resolveVariables(paras[1]));
					// replaces include command with filecontent...
					commands.merge(includeCommands, a);
					// so restart at same index...
					a--;
				}
				else if (Command.SYNC.equals(paras[0]))
				{
					if (sync != null)
					{
						sync.addWaiter(this);
					}
					else
					{
						error("NO SYNC!");
					}
				}
				else if (Utools.isIn(paras[0], Command.CLEAR))
				{
					if (paras.length == 1)
					{
						HashMap<String, String> variablesTemp = new HashMap<String, String>(variables);
						Iterator<String> it = variablesTemp.keySet().iterator();
						while (it.hasNext())
						{
							String key = it.next();
							if (!CURRENT_RESULT_KEY.equalsIgnoreCase(key))
							{
								if (paras.length > 1 && paras[1].contains(key))
								{
									continue;
								}
								variables.remove(key);
							}
						}
						si.clear();
					}
					else if (paras[1].equalsIgnoreCase(Command.COOKIES))
					{
						si.clear();
					}
				}
				else if (Command.SET.equals(paras[0]))
				{
					processSetCommand(paras);
				}
				else if (Command.INCR.equals(paras[0]) && paras.length > 1)
				{
					setVariable(paras[1], "" + (new Long(variables.get(paras[1])) + 1));
				}
				else if (Command.DECR.equals(paras[0]) && paras.length > 1)
				{
					setVariable(paras[1], "" + (new Long(variables.get(paras[1])) - 1));
				}
				else if (Utools.isIn(paras[0], Command.WAITG_SLEEPG))
				{
					Thread.sleep((long) Math.abs(ran.nextGaussian() * (new Long(paras[1]).intValue())));
				}
				else if (Utools.isIn(paras[0], Command.WAITR_SLEEPR))
				{
					Thread.sleep(ran.nextInt(new Long(paras[1]).intValue()));
				}
				else if (Utools.isIn(paras[0], Command.WAIT_SLEEP))
				{
					Thread.sleep(new Long(paras[1]).longValue());
				}
				else if (Command.PRINT.equals(paras[0]))
				{
					processPrintCommand(paras);
				}
				else if (Command.WRITE.equals(paras[0]) || Command.APPEND.equals(paras[0]))
				{
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					if (paras.length > 2)
						baos.write(enforceEscapes(resolveVariables(paras[2])).getBytes());
					else
						baos = nw.getNetResult().getReturnContentAsBaos();
					write(resolveVariables(paras[1]), baos, Command.APPEND.equals(paras[0]));
				}
				else if (Command.REN.equals(paras[0]))
				{
					tracer("RENAME " + paras[1] + "->" + paras[2] + ":" + new File(paras[1]).renameTo(new File(paras[2])));
				}
				else if (Utools.isIn(paras[0], Command.PRINTRESULT))
				{
					print(currentRet);
				}
				else if (Command.PACKRESULT.equals(paras[0]))
				{
					if (currentRet != null)
					{
						currentRet = CommonUtil.replace(currentRet.trim(), "\r", "");
						currentRet = CommonUtil.replace(currentRet.trim(), "\n", "");
						currentRet = CommonUtil.replace(currentRet.trim(), "\t", "");
					}
				}
				else if (Command.UPCASERESULT.equals(paras[0]))
				{
					if (currentRet != null)
					{
						currentRet = currentRet.trim().toUpperCase();
					}
				}
				else
				{
					processNetCommand(command, paras);
				}
			}
			catch (Throwable e)
			{
				Exception ex = new Exception("Command " + command + " caused Exception:" + e);
				ex.initCause(e);
				throw ex;
			}
		}
	}

	private void processNetCommand(Command cmd, String[] paras) throws Exception
	{
		Properties props = new Properties();
		URL url = null;
		try
		{
			int follow = 0;
			if (Command.FOLLOW.equals(paras[0]))
			{
				follow = Networker.FOLLOWMODE_DETAILED;
			}
			else if (Command.FOLLOWREDIR.equals(paras[0]))
			{
				follow = Networker.FOLLOWMODE_HIDDEN;
			}
			else if (Command.READ.equals(paras[0]))
			{
				follow = Networker.FOLLOWMODE_NOFOLLOW;
			}
			else
			{
				throw new Exception("Unknown command: " + cmd);
			}
			url = new URL(resolveVariables(paras[1]));
			if (paras.length > 2)
			{
				String bodyString = resolveVariables(paras[2]);
				if (bodyString != null && bodyString.length() > 0)
					props.put("<BODY>", bodyString);
				Properties rp = null;
				if (paras.length > 3)
				{
					rp = new Properties();
					StringTokenizer st = new StringTokenizer(resolveVariables(paras[3]), "|");
					while (st.hasMoreTokens())
					{
						String token = st.nextToken();
						StringTokenizer st2 = new StringTokenizer(token, "#");
						rp.put(st2.nextToken(), st2.nextToken());
					}
				}
				currentRet = nw.send(url, props, si, rp, follow);
			}
			else
			{
				currentRet = nw.send(url, null, si, null, follow);
			}
		}
		finally
		{
			ArrayList<Result> states = nw.getNetResult().getReturnStates();
			CSV_SEP = Appender.CSV_SEP;
			switch (mode)
				{
					case MODE_PERF:
						tracker(CSV_SEP + cmd.getTask() + " [" + states.size() + "];" + nw.getNetResult().getAggregatedReturnStates());
						break;
					case MODE_PERF_DETAIL:
						for (int a = 0; a < states.size(); ++a)
						{
							NetResult.Result result = (Result) states.get(a);
							tracker(CSV_SEP + cmd.task + CSV_SEP + cmd.getTask() + " " + (a + 1) + "\\" + states.size() + CSV_SEP + result.url + result);
						}
						break;
					default:
						break;
				}
			logger.log("CONTENT:", nw.getNetResult().getReturnContent());
		}
	}

	private void processPrintCommand(String[] paras) throws MalformedURLException
	{
		if (paras.length > 1)
		{
			if (Command.GET.equals(paras[1]))
			{
				int index = 0;
				if (paras.length > 4)
				{
					index = Integer.parseInt(paras[4]);
				}
				print(p.get(currentRet, paras[2], paras[3], index));
			}
			else if (Command.GETR.equals(paras[1]))
			{
				print(Utools.getBetweenR(currentRet, paras[2], paras[3]));
			}
			else if (paras[1].endsWith(Command.GET))
			{
				print(resolveVariables(paras[1].substring(0, paras[1].length() - Command.GET.length())) + p.get(currentRet, paras[2], paras[3]));
			}
			else if (Command.COOKIE.equals(paras[1]))
			{
				String text = null;
				if (paras.length > 2)
				{
					// REMINDER: Print cookie uses last url as default!
					text = si.getCookieValue(paras[2], (paras.length > 3 ? new URL(resolveVariables(paras[3])) : nw.getNetResult().getURL()));
				}
				else
				{
					// REMINDER: Print cookie uses last url as default!
					text = si.getCookies(nw.getNetResult().getURL());
				}
				print(text);
			}
			else
			{
				print(resolveVariables(paras[1]));
			}
		}
		else
		{
			print(currentRet);
		}
	}

	private String getTimeStamp()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
		return sdf.format(new Date());
	}

	private String getDateStamp()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(new Date());
	}

	private void processSetCommand(String[] paras) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException
	{
		if (Command.EXTENSION.equals(paras[1]))
		{
			Class clazz = Class.forName(paras[2]);
			ci = (CommandprocessorInterface) clazz.newInstance();
		}
		else if (Command.LOGFILE.equals(paras[1]))
		{
			File file = new File(paras[2]);
			String filename = file.getParent() + File.separator + Thread.currentThread() + getTimeStamp() + file.getName();
			CommonUtil.checkPath(filename);
			tracer("LOGFILE:" + logger.setFile(filename, (paras.length > 4 ? paras[4] : null)).getAbsolutePath());
		}
		else if (Command.NWTRACE.equals(paras[1]))
		{
			nw.trace = new Boolean(paras[2]).booleanValue();
		}
		else if (Command.COOKIETRACE.equals(paras[1]))
		{
			si.trace = new Boolean(paras[2]).booleanValue();
		}
		else if (Command.TRACE.equals(paras[1]))
		{
			trace = new Boolean(paras[2]).booleanValue();
		}
		else if (Command.AGENT.equals(paras[1]))
		{
			nw.AGENT = paras[2];
		}
		else if (Command.TIMEOUT.equals(paras[1]))
		{
			nw.TIMEOUT = new Integer(paras[2]);
		}
		else if (Command.PROXY.equals(paras[1]))
		{
			String proxy = null;
			int colonIndex = -1;
			int excludeIndex = -1;
			if (paras.length > 2 && (proxy = paras[2]) != null && ((colonIndex = proxy.indexOf(":")) > -1))
			{
				String domain = null;
				int atIndex = proxy.lastIndexOf("@");
				if (atIndex > -1)
				{
					int startIndex = 0;
					if (false && proxy.indexOf("\\") < colonIndex)
					{
						// deactivated
						int bSlashIndex = proxy.indexOf("\\");
						startIndex = bSlashIndex + 1;
						domain = proxy.substring(0, bSlashIndex);
					}
					final String username = proxy.substring(startIndex, colonIndex);
					final String pass = proxy.substring(colonIndex + 1, atIndex);
					colonIndex = proxy.indexOf(":", atIndex);
					excludeIndex = proxy.indexOf("/", colonIndex);
					ProxyAuthenticator.use(username, pass);
				}
				if (domain != null)
				{
					System.setProperty("http.auth.ntlm.domain", domain);
					// System.setProperty("http.auth.preference","NTLM");
				}
				if (colonIndex > -1)
				{
					Utools.setSystemProperty("proxySet", "true", new String[] { "", "http", "https" });
					//
					String host = proxy.substring(atIndex + 1, colonIndex);
					String port = proxy.substring(colonIndex + 1);
					if (excludeIndex != -1)
					{
						port = proxy.substring(colonIndex + 1, excludeIndex);
						String nph = proxy.substring(excludeIndex + 1);
						Utools.setSystemProperty("nonProxyHosts", nph, new String[] { "", "http", "https" });
					}
					Utools.setSystemProperty("proxyHost", host, new String[] { "", "http", "https" });
					Utools.setSystemProperty("proxyPort", port, new String[] { "", "http", "https" });
				}
			}
			else
			{
				Utools.setSystemProperty("proxySet", "false", new String[] { "", "http", "https" });
			}
		}
		else if (Command.MODE.equals(paras[1]))
		{
			mode = new Integer(paras[2]).intValue();
			if (paras.length > 3)
			{
				File file = new File(paras[3]);
				String filename = file.getParent() + File.separator + Thread.currentThread() + getTimeStamp() + file.getName();
				tracer("TRACKER:" + tracker.setFile(filename, (paras.length > 4 ? paras[4] : null)).getAbsolutePath());
			}
		}
		else if (paras.length == 2)
		{
			setVariable(paras[1], "");
		}
		else if (Command.GETXPATH.equals(paras[2]))
		{
			if (paras.length > 4)
			{
				String text = XMLHelper.getXPath(resolveVariables(paras[4]), paras[3]);
				setVariable(paras[1], text);
			}
			else
			{
				String text = XMLHelper.getXPath(currentRet, paras[3]);
				setVariable(paras[1], text);
			}
		}
		else if (Command.GETREGEX.equals(paras[2]))
		{
			int index = 0;
			if (paras.length > 5)
			{
				index = Integer.parseInt(paras[5]);
			}
			String text = p.getRexEx(paras[3], resolveVariables(paras[4]), index);
			setVariable(paras[1], text);
		}
		else if (Command.GET.equals(paras[2]))
		{
			int index = 0;
			if (paras.length > 5)
			{
				index = Integer.parseInt(paras[5]);
			}
			String text = p.get(currentRet, paras[3], paras[4], index);
			setVariable(paras[1], text);
		}
		else if (Command.GETR.equals(paras[2]))
		{
			String text = Utools.getBetweenR(currentRet, paras[3], paras[4]);
			setVariable(paras[1], text);
		}
		else if (Utools.isIn(paras[2], Command.GETNOTNULL))
		{
			String text = p.get(currentRet, paras[3], paras[4]);
			if (text != null)
			{
				setVariable(paras[1], text);
			}
		}
		else if (Command.COOKIE.equals(paras[2]))
		{
			// REMINDER: Set var cookie uses last used url as default!
			String text = si.getCookieValue(paras[3], (paras.length > 4 ? new URL(resolveVariables(paras[4])) : nw.getNetResult().getURL()));
			setVariable(paras[1], text);
		}
		else if (Command.HEADER.equals(paras[2]))
		{
			// use last url to start with
			String text = nw.getNetResult().getHeaderField(paras[3]);
			setVariable(paras[1], text);
		}
		else if (Command.COOKIE.equals(paras[1]))
		{
			String key = paras[2];
			String value = null;
			if (paras.length > 3 && paras[3] != null)
				value = resolveVariables(paras[3]);
			tracer("SETCOOKIE:" + key + "=" + value);
			if (value == null)
			{
				// REMINDER: Set cookie uses last&null url as default!
				si.addCookie(key, (paras.length > 4 ? new URL(resolveVariables(paras[4])) : null));
				if (paras.length <= 4)
					si.addCookie(key, (paras.length > 4 ? new URL(resolveVariables(paras[4])) : nw.getNetResult().getURL()));
			}
			else
			{
				// REMINDER: Set cookie uses last&null url as default!
				si.addCookie(key + "=" + value, (paras.length > 4 ? new URL(resolveVariables(paras[4])) : null));
				if (paras.length <= 4)
					si.addCookie(key + "=" + value, (paras.length > 4 ? new URL(resolveVariables(paras[4])) : nw.getNetResult().getURL()));
			}
		}
		else if (Command.ASK.equals(paras[2]))
		{
			String text = resolveVariables(paras[3]);
			System.err.println("[ASK]" + text);
			BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
			String line = reader.readLine().trim();
			setVariable(paras[1], line);
		}
		else if (Command.REPLACE.equals(paras[2]))
		{
			String key = paras[1];
			if (!key.startsWith("$"))
				key = "$" + key;
			if (!key.endsWith("$"))
				key += "$";
			String text = CommonUtil.replace(resolveVariables(key), paras[3], paras[4]);
			setVariable(key, text);
		}
		else if (Command.ENC.equals(paras[2]))
		{
			setVariable(paras[1], URLEncoder.encode(resolveVariables(paras[3]), "UTF-8"));
		}
		else if (Command.DEC.equals(paras[2]))
		{
			setVariable(paras[1], URLDecoder.decode(resolveVariables(paras[3]), "UTF-8"));
		}
		else if (Command.ENC64.equals(paras[2]))
		{
			setVariable(paras[1], new sun.misc.BASE64Encoder().encode(resolveVariables(paras[3]).getBytes()));
		}
		else if (Command.DEC64.equals(paras[2]))
		{
			setVariable(paras[1], new String(new sun.misc.BASE64Decoder().decodeBuffer(resolveVariables(paras[3]))));
		}
		else if (Command.TRIM.equals(paras[2]))
		{
			String text = resolveVariables(paras[3]);
			setVariable(paras[1], text);
		}
		else
		{
			setVariable(paras[1], resolveVariables(paras[2]));
		}
	}

	/**
	 * Get Variables-Map for accessing resulting data or to prefill
	 * 
	 * @return Hashmap (key,value)
	 */
	public HashMap<String, String> getVariables()
	{
		return variables;
	}

	/**
	 * Resolves variables
	 * 
	 * @param stringWithConstants
	 * @return
	 */
	private String resolveVariables(String stringWithConstants)
	{
		String ret = stringWithConstants;
		String temp = stringWithConstants;
		int round = 0;
		Pattern p = Pattern.compile("[$][A-Z0-9\\_]+[$]"); //$NON-NLS-1$
		Matcher m = p.matcher(ret);
		int maxLoops = 10;
		int loopCounter = 0;
		while (m.find() && (loopCounter++) < maxLoops)
		{
			round++;
			String match = ret.substring(m.start(), m.end());
			String replacement = null;
			if (CURRENT_RESPONSECODE_KEY.equalsIgnoreCase(match))
			{
				replacement = ""+nw.getNetResult().getResponseCode();
			}
			else if (CURRENT_RESPONSEMESSAGE_KEY.equalsIgnoreCase(match))
			{
				replacement = nw.getNetResult().getResponseMessage();
			}
			else if (CURRENT_RESULT_KEY.equalsIgnoreCase(match))
			{
				replacement = currentRet;
			}
			else if (DATESTAMP_KEY.equalsIgnoreCase(match))
			{
				replacement = getDateStamp();
			}
			else if (TIMESTAMP_KEY.equalsIgnoreCase(match))
			{
				replacement = getTimeStamp();
			}
			else
			{
				replacement = (String) variables.get(match.toUpperCase());
			}
			if (replacement != null && !replacement.equalsIgnoreCase(match))
			{
				temp = CommonUtil.replace(temp, match, replacement);
				try
				{
					Thread.sleep(50);
				}
				catch (InterruptedException e)
				{
					e.printStackTrace();
				}
				ret = temp;
				m.reset(temp);
			}
			else
			{
				ret = ret.substring(m.end() - 1);
				m.reset(ret);
			}
		}
		return temp;
	}

	/**
	 * Sets variable and checks variable name before
	 * 
	 * @param key
	 * @param value
	 */
	private void setVariable(String key, String value)
	{
		if (!key.startsWith("$"))
			key = "$" + key;
		if (!key.endsWith("$"))
			key += "$";
		// tracer("SET:" + key + "=" + value);
		variables.put(key, value);
	}

	void tracer(String text)
	{
		if (trace)
			logger.log("TRACE", text);
		Tracer.trace(text, trace);
	}

	/**
	 * Tracks measured data
	 * 
	 * @param text
	 */
	private void tracker(String text)
	{
		text = CSV_SEP + Thread.currentThread() + text;
		tracker.log("TRACK", text);
		Tracer.trace("<TRACK>" + text, trace);
	}

	/**
	 * Write text to specified file
	 * 
	 * @param filename
	 * @param text
	 * @throws IOException
	 */
	private void write(String filename, ByteArrayOutputStream baos, boolean append) throws IOException
	{
		File file = CommonUtil.checkPath(filename);
		FileOutputStream fos = new FileOutputStream(file, append);
		if (baos != null)
		{
			baos.writeTo(fos);
		}
		fos.flush();
		fos.close();
	}

	private String enforceEscapes(String text)
	{
		if (text != null)
		{
			text = text.replace("\\t", "\t");
			text = text.replace("\\n", "\n");
			text = text.replace("\\r", "\r");
		}
		return text;
	}

	/**
	 * Outputs and logs text
	 * 
	 * @param text
	 */
	private void print(String text)
	{
		text = enforceEscapes(text);
		logger.log("PRINT", text);
		System.out.println(">'" + text + "'");
		System.out.flush();
	}

	private boolean checkParaLength(String[] cmd, int length) throws Exception
	{
		if (cmd != null && cmd.length == length)
			return true;
		else if (cmd != null)
			error("Invalid command length: " + Arrays.toString(cmd));
		else
			throw new Exception("Null command-array given");
		return false;
	}

	/**
	 * Outputs and logs errors
	 * 
	 * @param text
	 */
	private void error(String text)
	{
		logger.log("ERROR", text);
		System.err.println("<ERROR>:" + text);
	}

	/**
	 * To run as thread
	 */
	public void run()
	{
		try
		{
			tracer(Thread.currentThread() + " is started !");
			processCommands();
		}
		catch (Throwable e)
		{
			error(e.toString());
			e.printStackTrace();
		}
	}

	public static void main(String[] args) throws Throwable
	{
		System.err.println(WebClient.class.getSimpleName() + " {V " + CommonUtil.getLM(WebClient.class) + "}");
		if (args.length > 0)
		{
			boolean ssl = true;
			if (args.length > 1 && "NOSSL".equalsIgnoreCase(args[1]))
			{
				ssl = false;
			}
			WebClient wc = new WebClient(ssl);
			if (args.length > 1)
			{
				HashMap<String, String> vars = wc.getVariables();
				for (int a = 1; a < args.length; ++a)
				{
					if (args[a].contains("="))
					{
						String[] arg = args[a].split("=");
						vars.put(arg[0], arg[1]);
					}
				}
			}
			WebCommandList cmds = new WebCommandList(wc, new File(args[0]));
			wc.processCommands(cmds);
		}
		else
		{
			ArrayList<String> lines = ListReader.readAsIs("./webclient_usage.txt");
			for (int a = 0; a < lines.size(); ++a)
			{
				System.err.println(lines.get(a));
			}
		}
	}

	public static void proceed(String cmdfile) throws Throwable
	{
		main(new String[] { cmdfile });
	}

}
