package de.j4ee.webloader;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

import de.j4ee.util.MemoryData;
import de.j4ee.util.logger.Appender;
/**
 * @author Kristian Martin
 *
 *	There is no Warranty
 */
class ClientThreader implements Runnable
{
	private String line=null;
	private Appender tracer=null;

	ClientThreader(Appender logger, String line) throws Throwable
	{
		tracer=(logger);
		this.line=line;
	}
	
	private void startWebClientTG() throws InterruptedException, IOException
	{
		Sync sync = new Sync();
		StringTokenizer st = new StringTokenizer(line, ",");
		st.nextToken();//command
		String netFile = st.nextToken();
		Integer threads = new Integer(st.nextToken());
		Integer iterations = new Integer(st.nextToken());
		Integer rampup = new Integer(st.nextToken());
		{
			ThreadGroup tg = new ThreadGroup("agents");
			for (int i = 0; i < iterations; ++i)
			{
				tracer.log(Appender.TYPE_TRACE,"Initialise ThreadGroup#" + i);
				for (int a = 0; a < threads; ++a)
				{
					WebClient cc = new WebClient(new File(netFile), sync);
					Thread thread = new Thread(tg, cc, "T" + a + "_" + threads + "#I" + i + "_" + iterations);
					thread.start();
					// rampup delay
					if (a < threads - 1)
					{
						Thread.sleep(rampup.intValue());
					}
				}
				tracer.log(Appender.TYPE_TRACE,"Started ThreadGroup#" + i + "(" + threads + "threads)");
				synchronized (tg)
				{
					while (tg.activeCount() > 0)
					{
						if (sync.counter == threads)
						{
							tracer.log(Appender.TYPE_TRACE,"Wakeup");
							sync.reset(tg);
						}
						tg.wait(100);
					}
				}
				tracer.log(Appender.TYPE_TRACE,"Finished ThreadGroup#" + i);
				// iterationdelay
				if (i < iterations - 1)
				{
					tracer.log(Appender.TYPE_TRACE,"Iterationdelay");
					Thread.sleep(rampup.intValue());
				}
				MemoryData md = new MemoryData();
				tracer.log(Appender.TYPE_TRACE,md.toStringExplained());
			}
		}
	}

	public void run()
	{
		try
		{
			startWebClientTG();
		}
		catch (InterruptedException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}


}
