package de.j4ee.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.sun.org.apache.xpath.internal.XPathAPI;

public class XMLHelper
{

	public static Document getXML(String in)
	{
		try
		{
			DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
			dfactory.setValidating(false);
			dfactory.setExpandEntityReferences(false);
			dfactory.setNamespaceAware(false);
			final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
			final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";// =XMLConstants.W3C_XML_SCHEMA_NS_URI;
			dfactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
			DocumentBuilder parser = dfactory.newDocumentBuilder();
			parser.setEntityResolver(new EntityResolver()
			{
				public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException
				{
					ByteArrayInputStream bais = new ByteArrayInputStream("".getBytes());
					return new InputSource(bais);
				}
			});
			parser.setErrorHandler(new ErrorHandler()
			{

				public void error(SAXParseException exception) throws SAXException
				{
					System.err.println(exception);
				}

				public void fatalError(SAXParseException exception) throws SAXException
				{
					System.err.println(exception);
				}

				public void warning(SAXParseException exception) throws SAXException
				{
					System.err.println(exception);
				}
			});
			Document xmldocTemp = parser.parse(new InputSource(new StringReader(in)));// ByteArrayInputStream(in.getBytes()));
			return xmldocTemp;
		}
		catch (SAXParseException e)
		{
			System.err.println("@Line: " + e.getLineNumber() + " Column: " + e.getColumnNumber());
			e.printStackTrace();
		}
		catch (SAXException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		catch (ParserConfigurationException e)
		{
			e.printStackTrace();
		}
		return null;
	}

	public static String getXPath(String in, String expr)
	{
		try
		{
			Node nl = XPathAPI.selectSingleNode(getXML(in), expr);
			if (nl == null)
				return null;
			return nl.getTextContent();
		}
		catch (Throwable e)
		{
			e.printStackTrace();
		}
		return null;
	}

	public static NodeList getXPathNodes(String in, String expr)
	{
		try
		{
			Node node = getXML(in);
			if (node != null)
			{
				NodeList nl = XPathAPI.selectNodeList(node, expr);
				return nl;
			}
		}
		catch (Throwable e)
		{
			e.printStackTrace();
		}
		return null;
	}

	public static HashMap<String, String> getNodeValueTextContentMap(Node node)
	{
		HashMap<String, String> hm = null;
		if (node != null)
		{
			hm = new HashMap<String, String>();
			NodeList nl = node.getChildNodes();
			int size=nl.getLength();
			for (int a=0;a<size;++a)
			{
				Node subNode=nl.item(a);
				hm.put(getNodeName(subNode), subNode.getTextContent());
			}
		}
		return hm;
	}
	
	public static String getNodeName(Node node)
	{
		String name = null;
		if (node != null)
		{
			name = node.getLocalName();
			if (name == null)
				name = node.getNodeName();
		}
		return name;
	}

	public static String beautify(String in) throws IOException
	{
		return new String(documentToByteArray(getXML(in)));
	}

	/**
	 * 
	 * @param location . = somewhere, / = absolute from root
	 * @param nodeName
	 * @return
	 */
	public static String getExprToGetNodeByName(char location, String nodeName)
	{
		String xpr = null;
		xpr = location + "/*[";
		{
			xpr += "(local-name()='" + nodeName + "')";
		}
		xpr += "]";
		return xpr;
	}
	
	
	/**
	 * 
	 * @param location . = somewhere, / = absolute from root
	 * @param value
	 * @return
	 */
	public static String getExprToGetNodeByValue(char location, String value)
	{
		String xpr = null;
		xpr = location + "/*[";
		{
			xpr += "'" + value + "'";
		}
		xpr += "]";
		return xpr;
	}
	
	public static byte[] documentToByteArray(Document xmldoc) throws IOException
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		save(xmldoc, baos);
		return (baos.toByteArray());
	}

	public static void saveDocument(Document xmldoc, File file) throws IOException
	{
		if (file != null)
		{
			FileOutputStream fos = new FileOutputStream(file);
			save(xmldoc, fos);
			fos.close();
		}
	}

	private static void save(Document xmldoc, OutputStream os) throws IOException
	{
		if (xmldoc != null && xmldoc.getDocumentElement() != null)
		{
			OutputFormat of = new OutputFormat("XML", "UTF-8", true);
			of.setIndent(4);
			of.setIndenting(true);
			of.setLineWidth(200);
			XMLSerializer serializer = new XMLSerializer(os, of);
			serializer.setNamespaces(true);
			// As a DOM Serializer
			serializer.asDOMSerializer();
			serializer.serialize(xmldoc);
			os.close();
		}
	}

}
