package de.j4ee.util.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.SwingUtilities;



public class ToolTipExtention extends MouseAdapter
{
	private transient OraPanel panel = null;
	private transient Content desc = null;

	public ToolTipExtention(Content desc)
	{
		this.desc = desc;
	}

	public void mouseEntered(MouseEvent e)
	{
		panel = OraPanel.showContent(SwingUtilities.getRoot((Component) e.getSource()), desc, true);
	}

	public void mouseExited(MouseEvent e)
	{
		if (panel != null)
		{
			panel.dispose();
			panel = null;
		}
	}

	public static void addToolTipExtension(Component component, Content desc)
	{
		component.addMouseListener(new ToolTipExtention(desc));
	}
}
