/*
 * Created on 05.01.2005
 */
package de.j4ee.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

import de.j4ee.util.CommonUtil;
import de.j4ee.util.config.Condition;
public class OraPanel extends JFrame implements ClosableComponent, ActionListener
{
	private static final long serialVersionUID = -3210754026836597980L;
	private JEditorPane jedit = null;
	private JPanel panel = null;
	private boolean autoHide = true;
	private Timer timer = null;

	private OraPanel(String title, boolean undecorated)
	{
		super(title==null?"Tip":title);
		if (undecorated)
		{
			setUndecorated(undecorated);
		}
		ComponentTerminater.instance.register(this, this);
		JScrollPane scrollpane = new JScrollPane();
		jedit = new JEditorPane("text/html", "---");
		jedit.setFont(FixedFonts.textFont);
		scrollpane.getViewport().add(jedit);
		panel = new JPanel(new BorderLayout());
		panel.add(scrollpane);
		getContentPane().add(panel, BorderLayout.CENTER);
		jedit.setEditable(false);
		scrollpane.setLocation(0, 0);
		jedit.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		pack();
		panel.setSize(300, 300);
	}

	/**
	 * Closes window and terminates timer
	 */
	public void close()
	{
		if (panel != null)
		{
			panel.removeAll();
		}
		if (timer!=null)
		{
			timer.stop();
			timer=null;
		}
		this.dispose();
		panel = null;
		jedit = null;
		timer = null;
	}

	public boolean isAutoHide()
	{
		return autoHide;
	}

	/**
	 * Sets timer that will force will to close if inactive after given duration
	 * @param millis
	 */
	public void setTimerDelay(int millis)
	{
		if (timer == null)
		{
			timer = new Timer(millis, this);
			timer.setDelay(millis);
			timer.start();
		}
		else
		{
			timer.setDelay(millis);
			timer.restart();
		}
	}

	public void setAutoHide(boolean autoHide)
	{
		this.autoHide = autoHide;
		if (autoHide && panel.getComponentCount() == 2)
		{
			panel.remove(1);
			validate();
		}
		else if (!autoHide && panel.getComponentCount() == 1)
		{
			JButton close = new JButton("Close");
			close.addActionListener(new ActionListener()
			{

				public void actionPerformed(ActionEvent e)
				{
					setAutoHide(true);
					close();
				}
			});
			panel.add(close, BorderLayout.SOUTH);
			validate();
			toFront();
		}
	}

	/**
	 * Shows content in a new frame
	 * @param parent used to set location relative to
	 * @param desc containing the actual content
	 * @param undecorated flag indicating whether to use frame-decoration
	 * @return OraPanel
	 */
	public static OraPanel showContent(Component parent, Content desc, boolean undecorated)
	{
		OraPanel panel = showContent(desc, undecorated);
		panel.setSize(desc.getDimension());
		CommonUtil.setRelativeLocation(parent, panel);
		panel.setVisible(true);
		return panel;
	}

	/**
	 * Shows content in a new frame
	 * @param point used to set location to
	 * @param desc containing the actual content
	 * @param undecorated flag indicating whether to use frame-decoration
	 * @return OraPanel
	 */
	public static OraPanel showContent(Point point, Content desc, boolean undecorated)
	{
		OraPanel panel = showContent(desc, undecorated);
		panel.setSize(desc.getDimension());
		panel.setLocation(point);
		panel.setVisible(true);
		return panel;
	}

	private static OraPanel showContent(Content cont, boolean undecorated)
	{
		undecorated = (undecorated && !Condition.getInstance().useBackwardMode());
		OraPanel ora = new OraPanel(cont.getTitle(), undecorated);
		{
			String ft = null;
			if (undecorated && cont.getTitle()!=null)
			{
				ft = "<html><body>"+"<h1>" + cont.getTitle() + "</h1>" + cont.getContent() + "</body></html>\r\n";
			}
			else
			{
				ft = "<html><body>" + cont.getContent() + "</body></html>\r\n";
			}
			ora.jedit.setText(ft);
			ora.jedit.setEnabled(true);
			ora.jedit.setCaretPosition(0);
		}
		return ora;
	}

	public void actionPerformed(ActionEvent e)
	{
		if (this.isActive())//extends duration as long window is active
		{
			setTimerDelay(2000);
		}
		else if (autoHide)
		{
			close();
		}
	}

}