package de.j4ee.util.ui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import de.j4ee.util.CommonUtil;
import de.j4ee.util.config.Configurator;

public class ConfigPane extends JDialog implements ClosableComponent
{
	private static final long serialVersionUID = 1L;
	private ArrayList components = new ArrayList();
	private Configurator editor = null;
	private Frame owner = null;
	private int exit = -1;

	/**
	 * This class is used to change options.
	 * 
	 * @param owner
	 *            please pass new JFrame()
	 * @param editor
	 *            containing options
	 * @param title
	 *            dialog title
	 */
	public ConfigPane(Frame owner, Configurator editor, String title)
	{
		super(owner, title);
		this.owner = owner;
		setTitle(title);
		setModal(true);
		ComponentTerminater.addCloseOnDispose(this);
		this.editor = editor;
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		JButton cancelButton = new JButton("Cancel");
		JButton applyButton = new JButton("OK");
		cancelButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				close();
			}
		});
		applyButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				try
				{
					save();
					exit = 0;
					close();
				}
				catch (Exception e1)
				{
					JOptionPane.showMessageDialog(ConfigPane.this.owner, e1, "Error", JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		ComponentTerminater.addKeyListener(mainPanel, applyButton, cancelButton);
		TreeMap map=new TreeMap(editor.getMap());
		JPanel panel = new JPanel(new GridLayout(map.size(), 2));
		Iterator it = map.entrySet().iterator();
		int width = 500;
		while (it.hasNext())
		{
			Map.Entry entry = (Map.Entry) it.next();
			String key = entry.getKey().toString();
			JLabel label=new JLabel(key);
			label.setVerticalAlignment(SwingConstants.TOP);
			panel.add(label);
			Object value = entry.getValue();
			JComponent component = null;
			if (value instanceof Boolean)
			{
				component = new JCheckBox();
				((JCheckBox) component).setSelected(((Boolean) value).booleanValue());
			}
			else if (value instanceof JComponent)
			{
				component = (JComponent) value;
			}
			else if (value instanceof Object[])
			{
				component=new JComboBox((Object[])value);
			}
			else
			// if (value instanceof String)
			{
				component = new JTextField(value.toString());
			}
			ComponentTerminater.addKeyListener(component, applyButton, cancelButton);
			component.setName(key);
			components.add(component);
			panel.add(component);
		}
		mainPanel.add(new JScrollPane(panel), BorderLayout.CENTER);
		mainPanel.add(new JPanel(), BorderLayout.WEST);
		JPanel cPanel = new JPanel();
		cPanel.add(cancelButton);
		cPanel.add(applyButton);
		mainPanel.add(cPanel, BorderLayout.SOUTH);
		getContentPane().add(mainPanel);
		setSize(width, map.size() * 25 + 100);
		CommonUtil.setRelativeLocation(owner, this);
		validate();
		// pack();
		setSize(width, map.size() * 30 + 100);
		setVisible(true);
		repaint();
	}

	public void close()
	{
		components.clear();
		components = null;
		removeAll();
		setVisible(false);
		dispose();
		if (owner != null && !owner.isVisible())
		{
			// if not visible then close parent as well
			owner.dispose();
		}
		owner = null;
	}

	/**
	 * 
	 * @return code other than -1 indicates that screen was not cancelled/closed
	 */
	public int getExitCode()
	{
		return exit;
	}

	private void save() throws Exception
	{
		Map map = editor.getMap();
		for (int a = 0; a < components.size(); ++a)
		{
			JComponent component = (JComponent) components.get(a);
			String key = component.getName();
			Object value = map.get(key);
			if (value instanceof Boolean)
			{
				if (component instanceof JCheckBox)
				{
					value = new Boolean(((JCheckBox) component).isSelected());
				}
			}
			else if (value instanceof String)
			{
				if (component instanceof JTextField)
				{
					value = ((JTextField) component).getText().trim();
				}
			}
			else if (value instanceof Object[])
			{
				if (component instanceof JComboBox)
				{
					value=((JComboBox)component).getSelectedItem();
				}
			}
			else if (value instanceof Integer)
			{
				if (component instanceof JTextField)
				{
					value = new Integer(((JTextField) component).getText().trim());
				}
			}
			map.put(key, value);
		}
		editor.save();
	}

}
