package de.j4ee.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;

import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ComponentTerminater
{
	private ArrayList<Registry> instances = new ArrayList<Registry>();
	public static final ComponentTerminater instance = new ComponentTerminater();

	/**
	 * This method is used for custom JFrames
	 * 
	 * @param closableComponent
	 * @param window
	 */
	public void register(final ClosableComponent closableComponent, Window window)
	{
		final Registry registry = new Registry(closableComponent, window);
		instances.add((registry));
		if (window != null)
		{
			window.addWindowListener(new WindowAdapter()
			{
				public void windowClosing(WindowEvent e)
				{
					registry.close();
					instances.remove(registry);
				}
			});
		}
	}

	
	public void register(final ClosableComponent closableComponent)
	{
		final Registry registry = new Registry(closableComponent);
		instances.add((registry));
	}
	
	/**
	 * This method is used for custom JFrames
	 * 
	 * @param closableComponent
	 * @param window
	 */
	public void register(final ClosableComponent closableComponent, JInternalFrame frame)
	{
		final Registry registry = new Registry(closableComponent, frame);
		instances.add((registry));
		if (frame != null)
		{
			frame.addInternalFrameListener(new InternalFrameAdapter()
			{
				public void internalFrameClosing(InternalFrameEvent e)
				{
					registry.close();
					instances.remove(registry);
				}
			});
		}
	}

	public void closeAllFrames()
	{
		for (int a = 0; a < instances.size(); ++a)
		{
			Registry registry = (Registry) instances.get(a);
			if (registry != null)
			{
				registry.close();
			}
		}
		instances.clear();
	}

	static class Registry
	{
		WeakReference registerableCloseable_wr = null;
		WeakReference window_wr = null;
		WeakReference iFrame_wr = null;
		String title = null;

		public Registry(ClosableComponent rf)
		{
			registerableCloseable_wr = new WeakReference(rf);
		}
		
		public Registry(ClosableComponent rf, JInternalFrame iframe)
		{
			this(rf);
			if (iframe != null)
			{
				iFrame_wr = new WeakReference(iframe);
				title = this + "|" + iframe.getTitle();
			}
		}

		public Registry(ClosableComponent rf, Window window)
		{
			this(rf);
			if (window != null)
			{
				window_wr = new WeakReference(window);
				title = this + "|" + window_wr + "|" + rf;
			}
		}

		public void close()
		{
			if (window_wr != null)
			{
				Window window = (Window) window_wr.get();
				if (window != null)
				{
					window.dispose();
					removeComponents(window);
				}
			}
			if (iFrame_wr != null)
			{
				JInternalFrame frame = (JInternalFrame) iFrame_wr.get();
				if (frame != null)
				{
					frame.dispose();
					removeComponents(frame);
				}
			}
			if (registerableCloseable_wr != null)
			{
				ClosableComponent registerableCloseable = (ClosableComponent) registerableCloseable_wr.get();
				if (registerableCloseable != null)
				{
					registerableCloseable.close();
				}
			}
			registerableCloseable_wr = null;
			window_wr = null;
		}

		public String toString()
		{
			if (title != null)
				return title;
			else
				return super.toString();
		}
	}

	/**
	 * This method is used by custom JDialogs
	 * 
	 * @param closableComponent
	 */
	public static void addCloseOnDispose(final ClosableComponent closableComponent)
	{
		((Window) closableComponent).addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				closableComponent.close();
				removeComponents((Window) closableComponent);
			}
		});
		(((Window) closableComponent)).addKeyListener(new KeyAdapter()
		{
			public void keyPressed(KeyEvent e)
			{
				if (e.getKeyCode() == 27)
				{
					closableComponent.close();
					removeComponents((Window) closableComponent);
				}
			}
		});
	}

	public static void addKeyListener(JComponent closableComponent, final JButton applyButton, final JButton cancelButton)
	{
		(closableComponent).addKeyListener(new KeyAdapter()
		{
			public void keyPressed(KeyEvent e)
			{
				if (e.getKeyCode() == 10)
				{
					applyButton.doClick();
				}
				else if (e.getKeyCode() == 27)
				{
					cancelButton.doClick();
				}
			}

		});
	}

	private static void removeComponents(Window comp)
	{
		removeListener(comp, comp.getListeners(WindowListener.class));
		removeListener(comp, comp.getListeners(KeyListener.class));
		removeComponents(comp.getComponents());
	}

	private static void removeComponents(JComponent comp)
	{
		removeComponents(comp.getComponents());
	}

	private static void removeComponents(Container comp)
	{
		removeComponents(comp.getComponents());
	}

	private static void removeComponents(Component c[])
	{
		for (int a = 0; a < c.length; ++a)
		{
			Component obj = c[a];
			if (obj instanceof AbstractButton)
			{
				AbstractButton button = (AbstractButton) obj;
				ActionListener cl[] = (ActionListener[]) (button.getListeners(ActionListener.class));
				for (int b = 0; b < cl.length; ++b)
				{
					button.removeActionListener(cl[b]);
				}
				button.removeAll();
			}
			else if (obj instanceof JComponent)
			{
				removeComponents(((JComponent) obj));
				(((JComponent) obj)).removeAll();
			}
			else if (Container.class.isAssignableFrom(obj.getClass()))
			{
				removeComponents(((Container) obj));
				(((Container) obj)).removeAll();
			}
			else
			{
				System.err.println(obj);
			}
		}
	}

	private static void removeListener(Component owner, EventListener[] listeners)
	{
		for (int a = 0; a < listeners.length; ++a)
		{
			EventListener el = listeners[a];
			if (el instanceof WindowListener)
			{
				((Window) owner).removeWindowListener((WindowListener) el);
			}
			else if (el instanceof KeyListener)
			{
				owner.removeKeyListener((KeyListener) el);
			}
			else if (el instanceof MouseListener)
			{
				owner.removeMouseListener((MouseListener) el);
			}
		}
	}
}
