package de.j4ee.util.logger.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;

import de.j4ee.util.Tracer;
import de.j4ee.util.logger.LoggerConfig;
import de.j4ee.util.logger.LoggerInterface;
public class Log4JLogger implements LoggerInterface
{
	private static String log4jPropertyFile = "log4j.properties";
	private static Class log4jClass = null;
	public static boolean success = true;
	private Object log4JObject = null;
	static
	{
		try
		{
			boolean isUseOfLOG4JDisabled = LoggerConfig.getInstance().isLog4JDisabled();
			if (!isUseOfLOG4JDisabled)
			{
				File file = new File(log4jPropertyFile);
				boolean configFileAvailable = file.exists();
				log4jClass = Class.forName("org.apache.log4j.Logger");
				{
					// set config initial
					Class log4jConfigClass = Class.forName("org.apache.log4j.PropertyConfigurator");
					if (configFileAvailable)// then use file
					{
						Method method = log4jConfigClass.getDeclaredMethod("configure", new Class[] { String.class });
						method.invoke(log4jConfigClass, new Object[] { log4jPropertyFile });
					}
					else
					// else use standard
					{
						Properties props = new Properties();
						props.put("log4j.rootLogger", "INFO, A1");
						props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
						props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
						Method method = log4jConfigClass.getDeclaredMethod("configure", new Class[] { Properties.class });
						method.invoke(log4jConfigClass, new Object[] { props });
					}
				}
				System.out.println("LOG4J found!");
			}
			else
			{
				System.out.println("LOG4J not used!");
				success = false;
			}
		}
		catch (Throwable e)
		{
			System.out.println("LOG4J not found -> using internal logging!");
			success = false;
		}
	}

	public Log4JLogger(Class clazz) throws Exception
	{
		if (success)
		{
			Method method = log4jClass.getDeclaredMethod("getLogger", new Class[] { Class.class });
			log4JObject = method.invoke(log4jClass, new Object[] { clazz });
		}
		else
		{
			throw new Exception("Log4J usage not possible!");
		}
	}

	public void info(Object text)
	{
		callImplementation("info", text);
	}

	public void warn(Object text)
	{
		callImplementation("warn", text);
	}

	public void debug(Object text)
	{
		callImplementation("debug", text);
	}

	public void error(Object text)
	{
		callImplementation("error", text);
	}

	private void callImplementation(String type, Object text)
	{
		try
		{
			Method m = log4JObject.getClass().getMethod(type, new Class[] { Object.class });
			m.invoke(log4JObject, new Object[] { text });
		}
		catch (Exception e)
		{
			Tracer.printThrowable(e);
		}
	}

}
