package de.j4ee.util.logger.impl;

import de.j4ee.util.Tracer;
import de.j4ee.util.logger.LoggerInterface;
public class IntermediateLogger implements LoggerInterface
{
	private Class clazz = null;

	public IntermediateLogger(Class clazz)
	{
		this.clazz = clazz;
	}

	private void log(String type, Object text)
	{
		{
			// Errors can be traced printed
			if ("error".equals(type))
			{
				errorLog(type, text);
			}
			// Debug logs are not printed without proper logger except its
			// configured to do the same
			else if ("debug".equals(type))
			{
				debugLog(type, text);
			}
			else if (!"debug".equals(type))
			{
				defaultLog(type, text);
			}
		}
	}

	private void errorLog(String type, Object obj)
	{
		String poo = Tracer.getPointOfOccurence(3);
		defaultLog("# " + type + " in " + poo, obj);
	}

	private void debugLog(String type, Object obj)
	{
		String pre = " ";
		pre = "[" + clazz + "]";
		if (obj instanceof Throwable)
		{
			sendError("*" + pre + type + ":\n\t", Tracer.getException((Throwable) obj));
		}
		else
		{
			sendError("*" + pre + type + ":", obj);
		}
	}

	private void defaultLog(String type, Object obj)
	{
		String pre = " ";
		if ("warn".equals(type))
		{
			sendLog("#" + pre + type + ":" + obj);
		}
		else
		{
			sendLog("*" + pre + type + ":" + obj);
		}
	}

	private void sendError(String type, Object obj)
	{
		System.err.println(type + obj);
	}


	private void sendLog(String text)
	{
		System.err.println(text);
		System.err.flush();
	}

	public void info(Object text)
	{
		log("info", text);
	}

	public void warn(Object text)
	{
		log("warn", text);
	}

	public void debug(Object text)
	{
		log("debug", text);
	}

	public void error(Object text)
	{
		log("error", text);
	}
	
}
