package de.j4ee.util.logger.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;

import de.j4ee.util.CommonUtil;
import de.j4ee.util.Tracer;
import de.j4ee.util.config.Condition;
import de.j4ee.util.logger.LoggerConfig;
import de.j4ee.util.logger.LoggerInterface;
import de.j4ee.util.logger.MyLoggerWrapper;
public class DefaultLogger implements LoggerInterface
{
	private static PrintStream out = System.out;
	private static PrintStream err = System.err;
	private static boolean traceError = true;
	private static boolean logDebug = false;
	private static boolean logToFile = false;
	private static boolean logToConsole = false;
	private static BufferedWriter fw = null;
	private Class clazz = null;
	private boolean initialized = false;

	private void init()
	{
		LoggerConfig config = null;
		if (!initialized && (config = LoggerConfig.getInstance()) != null)
		{
			initialized = true;
			if (config.useCoreOut() && !Condition.getInstance(false).isApplet())
			{
				// use real streams instead of possible wrapped ones
				err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
				out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
			}
			logDebug = (config.isDebug());
			if (logDebug)
			{
				logToConsole = (config.isDebugToConsole());
				logToFile = (config.isDebugToFile());
				if (logToFile)
				{
					// Default one logfile for every run
					String dd = "FlatLog";
					if (config.isUseTimeStampForDebugFile())
					{
						// Every run will create new logfile
						java.text.DateFormat tf = new java.text.SimpleDateFormat("yyyy-MM-dd HH_mm_ss");
						java.util.Calendar calendar = new java.util.GregorianCalendar();
						dd = tf.format(calendar.getTime());
					}
					try
					{
						fw = new BufferedWriter(new FileWriter(dd + ".log", false));
						logToFile = true;
						logDebug = true;
					}
					catch (IOException e)
					{
						logToFile = false;
					}
				}
			}
		}
	}

	public DefaultLogger(Class clazz)
	{
		init();
		this.clazz = clazz;
	}

	private void log(String type, Object object)
	{
		{
			// Errors can be traced printed
			if ("error".equals(type) && traceError)
			{
				errorLog(type, object);
			}
			// Debug logs are not printed without proper logger except its
			// configured to do the same
			else if ("debug".equals(type) && logDebug)
			{
				debugLog(type, object);
			}
			else if (!"debug".equals(type))
			{
				// if (logDebug)
				{
					// if (logToConsole)
					{
						defaultLog(type, object);
					}
					if (logToFile)
					{
						debugLog(type, object);
					}
				}
			}
		}
	}

	private void errorLog(String type, Object obj)
	{
		String poo = Tracer.getPointOfOccurence(3);
		defaultLog("# " + type + " in " + poo, obj);
	}

	private void debugLog(String type, Object obj)
	{
		String pre = " ";
		if (logDebug)
		{
			pre = "[" + clazz + "]";
		}
		if (obj instanceof Throwable)
		{
			sendError("*" + pre + type + ":\n\t", Tracer.getException((Throwable) obj));
		}
		else
		{
			sendError("*" + pre + type + ":", obj);
		}
	}

	private void defaultLog(String type, Object obj)
	{
		String pre = " ";
		if ("warn".equals(type))
		{
			sendLog("#" + pre + type + ":" + obj);
		}
		else
		{
			sendLog("*" + pre + type + ":" + obj);
		}
	}

	private void sendError(String type, Object obj)
	{
		if (logToConsole || fw == null)
		{
			err.println(type + obj);
		}
		else if (logToFile)
		{
			try
			{
				if (obj instanceof Throwable)
				{
					fw.write(type + CommonUtil.lineSep);
					sendError((Throwable) obj);
				}
				else
				{
					fw.write(type + obj + CommonUtil.lineSep);
					fw.flush();
				}
			}
			catch (Exception e)
			{
				logToFile = false;
				MyLoggerWrapper.getLogger(getClass()).error("Error during writting logfile:" + e);
			}
		}
	}

	private void sendError(Throwable ex) throws IOException
	{
		fw.write(ex.toString() + CommonUtil.lineSep);
		fw.flush();
		StackTraceElement[] ste = ex.getStackTrace();
		for (int a = 0; a < ste.length; ++a)
		{
			fw.write("\t\t at " + ste[a] + CommonUtil.lineSep);
			fw.flush();
		}
		Throwable cause = ex.getCause();
		if (cause != null)
		{
			fw.write("Caused by: ");
			fw.flush();
			sendError(cause);
		}
	}

	private void sendLog(String text)
	{
		out.println(text);
		out.flush();
	}

	public void info(Object text)
	{
		log("info", text);
	}

	public void warn(Object text)
	{
		log("warn", text);
	}

	public void debug(Object text)
	{
		log("debug", text);
	}

	public void error(Object text)
	{
		log("error", text);
	}

}
