/*
 * Created on 20.02.2005
 *
 */
package de.j4ee.util.logger;

import de.j4ee.util.logger.impl.DefaultLogger;
import de.j4ee.util.logger.impl.Log4JLogger;

/**
 * @author Kristian Martin
 * 
 * There is no Warranty
 * 
 * This Class wrappes Log4J to insure logging even it is not available
 */
public class MyLoggerWrapper
{
	private static boolean log4jIsAvailable = Log4JLogger.success;

	public static LoggerInterface getLogger(Class clazz)
	{
		if (log4jIsAvailable)
		{
			try
			{
				return new Log4JLogger(clazz);
			}
			catch (Exception e)
			{
				log4jIsAvailable = false;
			}
		}
		return new DefaultLogger(clazz);
	}

}