package de.j4ee.util.logger;

import de.j4ee.util.AbstractConfig;
import de.j4ee.util.Tracer;

public class LoggerConfig extends AbstractConfig
{
	private static final long serialVersionUID = -7129173975965327568L;
	private final static String CONFIG_FILENAME = "logger_setting.conf";
	//
	private final static String DOMAIN = "de.j4ee.util";
	private final static String PREFIX_LOGGER = "logger.";
	private final static String KEY_DEBUG = PREFIX_LOGGER + "debug";
	private final static String KEY_DEBUGOUTPUT = PREFIX_LOGGER + "debugOutput";
	private final static String KEY_COREOUT = PREFIX_LOGGER + "coreOut";
	private final static String KEY_DISABLEDL4J = PREFIX_LOGGER + "disableUseOfLOG4J";
	private final static String VALUE_DEBUG_CORE = "core";
	private final static String VALUE_DEBUGOUTPUT_CONSOLE = "console";
	private final static String VALUE_DEBUGOUTPUT_FLAT = "flatfile";
	private final static String VALUE_DEBUGOUTPUT_ROLL = "rollfile";
	private boolean isUseOfLOG4JDisabled = false;
	private boolean debugToFile = false;
	private boolean debugToConsole = false;
	private boolean debug = false;
	public boolean printAllExceptions = false;
	private boolean useTimeStampForDebugFile = false;
	private boolean useCoreOut = false;

	private static LoggerConfig currentConfig = (LoggerConfig) initializeInstance(new LoggerConfig(), CONFIG_FILENAME, DOMAIN, false);


	public synchronized static LoggerConfig getInstance()
	{
		return currentConfig;
	}

	public boolean isUseTimeStampForDebugFile()
	{
		return useTimeStampForDebugFile;
	}

	public boolean isDebug()
	{
		return debug;
	}

	public boolean useCoreOut()
	{
		return useCoreOut;
	}

	public boolean isDebugToFile()
	{
		return debugToFile;
	}

	public boolean isDebugToConsole()
	{
		return debugToConsole;
	}

	protected void init()
	{
		String value = getProperty(KEY_DEBUG);
		if (value != null && !"false".equalsIgnoreCase(value))
		{
			debug = true;
			printAllExceptions = VALUE_DEBUG_CORE.equalsIgnoreCase(value);
			value = getProperty(KEY_DEBUGOUTPUT);
			if (value != null)
			{
				debugToConsole = VALUE_DEBUGOUTPUT_CONSOLE.equalsIgnoreCase(value);
				useTimeStampForDebugFile = VALUE_DEBUGOUTPUT_ROLL.equalsIgnoreCase(value);
				debugToFile = VALUE_DEBUGOUTPUT_FLAT.equalsIgnoreCase(value) || useTimeStampForDebugFile;
			}
		}
		value = getProperty(KEY_COREOUT);
		if (value != null)
		{
			useCoreOut = Boolean.valueOf(value).booleanValue();
		}
		value = getProperty(KEY_DISABLEDL4J);
		if (value != null)
		{
			isUseOfLOG4JDisabled = Boolean.valueOf(value).booleanValue();
		}
	}

	public boolean isLog4JDisabled()
	{
		return isUseOfLOG4JDisabled;
	}
	
	/**
	 * This method prints throwables that are thrown further<br>
	 * It is used mainly for debugging purposes as it shows the real exception
	 * rather than caught once
	 * 
	 * @param t
	 */
	public void printThrownThrowable(Throwable t)
	{
		if (LoggerConfig.getInstance().printAllExceptions)
		{
			Tracer.printThrowable(t);
		}
	}
}
