package de.j4ee.util.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
/**
 * @author Kristian Martin
 *
 *	There is no Warranty
 */
public class Appender
{
	public final static String TYPE_TRACE="TRACE";
	public static String CSV_SEP = ";";
	FileWriter fw=null;
	String header=null;
	
	public Appender(String header)
	{
		this.header=header;
	}
	
	public Appender(String filename, String header)
	{
		this(header);
		setFile(filename, null);
	}
	
	private String getTimeStamp()
	{
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
		return sdf.format(new Date());
	}
	
	
	
	public File setFile(String filename, String csv_sep)
	{
		File file=null;
		try
		{
			if (csv_sep!=null)
				CSV_SEP=csv_sep;			
			file=new File(filename);
			file.createNewFile();
			fw=new FileWriter(file,true);
			log("HEADER",header);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		return file;
	}
	
	public String log(String type, String text)
	{
		String logtext=type+"[@"+getTimeStamp()+"]:"+text;
		if (TYPE_TRACE.equalsIgnoreCase(type))
		{
			System.err.println("--|>" + logtext);
		}
		if (fw!=null)
		{
			try
			{
				fw.write(logtext+CSV_SEP);
				fw.flush();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		return logtext;
	}


}
