package de.j4ee.util.fileWrapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import de.j4ee.util.CommonUtil;
import de.j4ee.util.Tracer;

public class URLFile extends File
{
	private static final long serialVersionUID = -7336399839741700242L;
	private URL url = null;
	private long length=0;
	

	public URLFile(java.net.URL url)
	{
		super(url.toString());
		this.url = url;
	}

	/**
	 * Method can be used for saving
	 */
	public boolean renameTo(File dest)
	{
		try
		{
			OutputStream fos=CommonUtil.getOutputStream(dest);
			InputStream is = getInputStream();
			byte buff[] = new byte[4096];
			int le = is.read(buff);
			while (le != -1)
			{
				fos.write(buff, 0, le);
				le = is.read(buff);
			}
			fos.flush();
			fos.close();
			length=dest.length();
		}
		catch (Throwable e)
		{
			return false;
		}
		return true;
	}

	public InputStream getInputStream() throws IOException
	{
		return url.openConnection().getInputStream();
	}

	public String getAbsolutePath()
	{
		return url.getFile();
	}

	public String getPath()
	{
		return url.toString();
	}

	public URI toURI()
	{
		try
		{
			return new URI(url.toString());
		}
		catch (URISyntaxException e)
		{
			Tracer.printThrowable(e);
		}
		return null;
	}

	public long length()
	{
		return length;
	}
}
