package de.j4ee.util.fileWrapper;

import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

import de.j4ee.util.config.PseudoClipboard;
import de.j4ee.util.ui.ConfigPane;

public class PseudoClipboardFile extends File
{
	private final static String name="Pseudo-clipboard";
	private static final long serialVersionUID = -7937409197988937955L;
	private JEditorPane jep=null;
	private Frame parent=null;
	
	public PseudoClipboardFile(Frame parent, JEditorPane jep)
	{
		this(jep);
		this.parent=parent;
	}
	
	public PseudoClipboardFile(JEditorPane jep)
	{
		super(name);
		this.jep=jep;
	}

	public void setContentToEditorPane(ByteArrayOutputStream baos)
	{
		Frame parentTemp=parent;
		parent=null;
		jep.setText(baos.toString().trim());
		jep.setEditable(false);
		PseudoClipboard editor=new PseudoClipboard(new JScrollPane(jep));
		new ConfigPane(parentTemp, editor,"Pseudo clipboard");
	}
	
	public OutputStream getOutputStream()
	{
		ByteArrayOutputStream baos=new OtherByteArrayOutputStream();
		return baos;
	}
	
	public InputStream getInputStream()
	{
		ByteArrayInputStream bais=new ByteArrayInputStream(jep.getText().getBytes());
		return bais;
	}
	
	public String getAbsolutePath()
	{
		return name;
	}

	public String getPath()
	{
		return name;
	}

	public long length()
	{
		return jep.getText().trim().length();		
	}
	
	public static File getInputEditorPaneFile(Frame parent)
	{
		JEditorPane jep=new JEditorPane("text", "");
		jep.setSize(100,300);
		PseudoClipboardFile epf=new PseudoClipboardFile(jep);
		PseudoClipboard editor=new PseudoClipboard(new JScrollPane(jep));
		ConfigPane conf=new ConfigPane(parent, editor,"Pseudo clipboard");
		if (conf.getExitCode()!=-1)
		{
			return epf;		
		}
		else
		{
			return null;
		}
	}
	
	public static File getOutputEditorPaneFile(Frame parent)
	{
		JEditorPane jep=new JEditorPane("text", "");
		jep.setSize(100,300);
		jep.setEditable(false);
		PseudoClipboardFile epf=new PseudoClipboardFile(parent,jep);
		return epf;
	}
	
	class OtherByteArrayOutputStream extends ByteArrayOutputStream
	{
		private boolean closed=false;
		
		public void close() throws IOException
		{
			super.close();
			if (!closed)
			{
				setContentToEditorPane(this);
			}
			closed=true;
		}
	}
	
}
