package de.j4ee.util.fileWrapper;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import de.j4ee.util.logger.LoggerConfig;

public class ClipboardFile extends File
{
	private final static String name="CLIPBOARD";
	private static final long serialVersionUID = -7937409197988937955L;
	
	public ClipboardFile()
	{
		super(name);
	}

	public void setContentToClipboard(ByteArrayOutputStream baos)
	{
		Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
		Transferable tf=new StringSelection(new String(baos.toByteArray()));
		systemClip.setContents(tf, null);
	}
	
	
	public OutputStream getOutputStream()
	{
		ByteArrayOutputStream baos=new OtherByteArrayOutputStream();
		return baos;
	}
	
	public InputStream getInputStream() throws IOException
	{
		Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
		Transferable transfer=systemClip.getContents(null);
		String data=null;
		try
		{
			data = (String) transfer.getTransferData( DataFlavor.stringFlavor);
		}
		catch (UnsupportedFlavorException e)
		{
			LoggerConfig.getInstance().printThrownThrowable(e);
		}
		ByteArrayInputStream bais=new ByteArrayInputStream(data.getBytes());
		return bais;
	}
	
	public String getAbsolutePath()
	{
		return name;
	}

	public String getPath()
	{
		return name;
	}

	public long length()
	{
		Clipboard systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
		Transferable transfer=systemClip.getContents(null);
		String data;
		try
		{
			data = (String) transfer.getTransferData( DataFlavor.stringFlavor );
			return data.length();
		}
		catch (Throwable e)
		{
			return -1;
		}
		
	}
	
	class OtherByteArrayOutputStream extends ByteArrayOutputStream
	{
		public void close() throws IOException
		{
			super.close();
			setContentToClipboard(this);
		}
	}

}
