package de.j4ee.util.csv.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import de.j4ee.util.Tracer;


public class LazyStreamReader implements ReaderInterface
{
	private Reader in = null;
	private int bufferPos = 0;
	private int maxBufferPos = 0;
	private int buffersize = 8193;// 8193;//2049;//16385;
	private char[] buffer = new char[buffersize];
	private int currentPos = 0;

	public LazyStreamReader(InputStream in)
	{
		this.in = new InputStreamReader(in);
	}

	public void reset()
	{
		try
		{
			if (currentPos != 0)
			{
				in.reset();
				bufferPos = 0;
				maxBufferPos = 0;
				currentPos = 0;
			}
		}
		catch (IOException e)
		{
			Tracer.printThrowable(e);
		}
	}

	public int step(int a)
	{
		currentPos += a;
		bufferPos += a;
		return currentPos;
	}

	public int stepOne()
	{
		++currentPos;
		++bufferPos;
		return currentPos;
	}

	public String getAbsString(int pos, int length)
	{
		String ret = null;
		// char c = (char) -1;
		if ((getAbsCharAt(pos + length - 1)) != (char) -1)
		{
			int ahead = pos - currentPos;
			ret = new String(buffer, bufferPos + ahead, length);
		}
		return ret;
	}

	public char getCurrentChar()
	{
		return getRelativeChar(0);
	}

	public char getRelativeChar(int ahead)
	{
		char ret = (char) -1;
		int aheadAvailable = maxBufferPos - bufferPos - 1;
		if (ahead > aheadAvailable)
		{
			boolean success = true;
			try
			{
				success = fillBuffer();
			}
			catch (IOException e)
			{
				Tracer.printThrowable(e);
				if (in != null)
				{
					try
					{
						in.close();
					}
					catch (IOException e1)
					{
						Tracer.printThrowable(e);
					}
				}
			}
			if (success)
			{
				aheadAvailable = maxBufferPos - bufferPos - 1;
				if (ahead <= aheadAvailable)
				{
					ret = buffer[bufferPos + ahead];
				}
			}
		}
		else
		{
			ret = buffer[bufferPos + ahead];
		}
		return ret;
	}

	public char getAbsCharAt(int pos)
	{
		int ahead = pos - currentPos;
		return getRelativeChar(ahead);
	}

	private boolean fillBuffer() throws IOException
	{
		boolean success = false;
		int available = maxBufferPos - bufferPos;
		int toRead = buffersize - available;

		System.arraycopy(buffer, bufferPos, buffer, 0, available);
		int read = in.read(buffer, available, toRead);
		maxBufferPos = available;
		if (read != -1)
		{
			maxBufferPos = available + read;
			success = true;
		}
		bufferPos = 0;
		return success;
	}

	public void close()
	{
		if (in != null)
		{
			try
			{
				in.close();
			}
			catch (IOException e)
			{
				Tracer.printThrowable(e);
			}
		}
	}
}
