package de.j4ee.util.csv.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FullReader implements ReaderInterface
{
	private StringBuffer data = null;
	private int textLength = -1;
	private int currentPos = 0;

	public FullReader(File file) throws IOException
	{
		textLength = (int) file.length();
		data = readFile(file);
	}

	private StringBuffer readFile(File file) throws IOException
	{
		StringBuffer content = new StringBuffer();
		byte[] dateiPuffer = new byte[8192];
		FileInputStream in = new FileInputStream(file);
		BufferedInputStream bis = new BufferedInputStream(in);
		try
		{
			int read = 0;
			while (true)
			{
				read = bis.read(dateiPuffer);
				if (read == -1)
				{
					break;
				}
				content.append(new String(dateiPuffer, 0, read));
			}
		}
		catch (IOException e)
		{
			throw e;
		}
		finally
		{
			in.close();
			bis.close();
		}
		return content;
	}

	public void reset()
	{
		currentPos = 0;
	}

	public int step(int a)
	{
		currentPos += a;
		return currentPos;
	}

	public String getAbsString(int pos, int length)
	{
		String t = null;
		if (textLength >= pos + length)
		{
			t = data.substring(pos, pos + length);
		}
		return t;
	}

	public char getAbsCharAt(int pos)
	{
		if (pos < textLength)
			return data.charAt(pos);
		else
			return (char) -1;
	}

	public char getCurrentChar()
	{
		return getAbsCharAt(currentPos);
	}

	public char getRelativeChar(int ahead)
	{
		return getAbsCharAt(currentPos + ahead);
	}

	public void close()
	{

	}

}
