package de.j4ee.util.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import de.j4ee.util.CommonUtil;

public class CsvReader
{
	private CsvTokenizer tokenizer = null;
	private boolean checkConsistence = false;
	private int firstRowColumnNumber = -1;
	private int rowCounter = 0;
	private int columnCounter = 0;

	public CsvReader(String text, String delim) throws IOException
	{
		tokenizer=new CsvTokenizer(text,delim);
	}
	
	public CsvReader(File file) throws IOException
	{
		tokenizer = new CsvTokenizer(file, ",");
	}

	public CsvReader(long length, InputStream is, String delim, boolean checkConsistence) throws IOException
	{
		tokenizer = new CsvTokenizer(length, is, delim);
		this.checkConsistence = checkConsistence;
	}
	
	public CsvReader(File file, String delim, boolean checkConsistence, boolean lazy) throws IOException
	{
		tokenizer = new CsvTokenizer(file, delim, lazy);
		this.checkConsistence = checkConsistence;
	}

	public CsvReader(File file, char delim, boolean checkConsistence) throws IOException
	{
		this(file, "" + delim, checkConsistence, true);
	}

	public void reset()
	{
		tokenizer.reset();
		rowCounter = 0;
		columnCounter = 0;
		firstRowColumnNumber = -1;
	}

	public String[] getLine() throws Throwable
	{
		String[] line = null;
		columnCounter = 0;
		String nt = "";
		try
		{
			if (tokenizer.hasMoreToken())
			{
				rowCounter++;
				if (firstRowColumnNumber != -1 && checkConsistence)
				{
					line = new String[firstRowColumnNumber];
					while (tokenizer.hasMoreToken() && nt != null)
					{
						nt = tokenizer.nextToken();
						if (nt != null)
						{
							line[columnCounter] = nt;
							++columnCounter;
						}
					}
					if (firstRowColumnNumber != columnCounter && tokenizer.hasMoreToken())
					{
						throw new IllegalArgumentException("Consistence check failed in line " + (rowCounter) + " (" + columnCounter
								+ "<>" + firstRowColumnNumber + " !)");
					}
				}
				else
				{
					line = new String[0];
					ArrayList row = new ArrayList();
					while (tokenizer.hasMoreToken() && nt != null)
					{
						nt = tokenizer.nextToken();
						if (nt != null)
						{
							row.add(nt);
						}
					}
					line = (String[]) row.toArray(line);
					firstRowColumnNumber = row.size();
				}
			}
		}
		catch (Throwable e)
		{
			System.err.println("Error " + e + " @" + getCurrentPos() + " with:'" + nt + "'(" + CommonUtil.printAsByteString(nt) + ")");
			throw e;
		}
		return line;
	}

	public String getCurrentPos()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("(Row:" + rowCounter + "/Column:" + columnCounter + ")");
		return sb.toString();
	}

	public void close()
	{
		if (tokenizer != null)
		{
			tokenizer.close();
		}
	}

}