package de.j4ee.util.config;

import de.j4ee.util.logger.LoggerInterface;
import de.j4ee.util.logger.MyLoggerWrapper;

public class Condition
{
	protected transient LoggerInterface logger = null;
	private static final long serialVersionUID = 1L;
	private boolean xmlApiFound = false;
	private boolean isApplet=false;
	private boolean isDemo=false;
	private Double javaVersion = new Double(1.3);

	private static Condition currentCondition = new Condition();

	private Condition()
	{
	}
	
	public static Condition getInstance(boolean initialize)
	{
		if (initialize)
		{
			return getInstance();
		}
		else
		{
			return currentCondition;
		}
	}

	public static Condition getInstance()
	{
		if (currentCondition.logger==null)
		{
			currentCondition.checkCurrentEnvironment();
		}
		return (Condition) currentCondition;
	}

	private void checkCurrentEnvironment()
	{
		logger=MyLoggerWrapper.getLogger(Condition.class);
		xmlApiFound = false;
		try
		{
			String xmlApiClass = "org.xml.sax.helpers.DefaultHandler";
			Class.forName(xmlApiClass);
			xmlApiFound = true;
		}
		catch (ClassNotFoundException e)
		{

		}
		String javaVersionTemp = System.getProperty("java.specification.version");
		if (javaVersionTemp != null)
		{
			javaVersion = new Double(javaVersionTemp);
		}
		if (useBackwardMode())
		{
			logger.warn("Old java version found, ORA will using backward mode only");
		}
		if (!xmlApiFound)
		{
			logger.warn("No xml-api found. This could negativly impact the save/load operations!");
		}

	}



	public boolean isXmlAvailable()
	{
		return xmlApiFound;
	}

	public boolean isApplet()
	{
		return isApplet;
	}
	public void setItsApplet(boolean applet)
	{
		this.isApplet=applet;
	}

	public boolean isDemo()
	{
		return isDemo;
	}

	public void setDemo(boolean isDemo)
	{
		this.isDemo = isDemo;
	}
	
	public boolean useBackwardMode()
	{
		return (javaVersion.doubleValue() < 1.4);
	}
	

}