package de.j4ee.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Map.Entry;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import sun.security.action.GetPropertyAction;

public class Utools
{
	private final static String dfltEncName = (String) AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
	public static String lb = "\n";
	public static String full_lb = "\r\n";
	public static String sep = "\";\"";

	/**
	 * Mostly used for proxyrelated sets having '','http','https' prefixes. Automatically adds '.' when not supplied
	 * 
	 * @param keyPostfix
	 * @param value
	 * @param prefixes
	 */
	public static void setSystemProperty(String keyPostfix, String value, String[] prefixes)
	{
		if (prefixes == null)
			System.setProperty(keyPostfix, value);
		else
		{
			for (int a = 0; a < prefixes.length; ++a)
			{
				if (prefixes[a] != null && prefixes[a].length() > 0)
				{
					if (prefixes[a].endsWith("."))
						System.setProperty(prefixes[a] + keyPostfix, value);
					else
						System.setProperty(prefixes[a] + "." + keyPostfix, value);
				}
				else
					System.setProperty(keyPostfix, value);
			}
		}
	}

	/**
	 * <p>
	 * Checks if two calendars represent the same day ignoring time.
	 * </p>
	 * 
	 * @param cal1 the first calendar, not altered, not null
	 * @param cal2 the second calendar, not altered, not null
	 * @return true if they represent the same day
	 * @throws IllegalArgumentException if either calendar is <code>null</code>
	 */
	public static boolean isSameDay(Calendar cal1, Calendar cal2)
	{
		if (cal1 == null || cal2 == null)
		{
			throw new IllegalArgumentException("The dates must not be null");
		}
		return (cal1.get(Calendar.ERA) == cal2.get(Calendar.ERA) && cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR) && cal1.get(Calendar.DAY_OF_YEAR) == cal2
				.get(Calendar.DAY_OF_YEAR));
	}

	/**
	 * Checks whether given input is a valid Integer
	 * @param input
	 * @return
	 */
	public static boolean isInteger(String input)
	{
		try
		{
			Integer.parseInt(input);
			return true;
		}
		catch (Throwable e)
		{
			return false;
		}
	}

	/**
	 * Checks whether supplied text is (equalsIgnoreCase) known in commata-separated patterns
	 * 
	 * @param text
	 * @param pattern
	 * @return flag
	 */
	public static boolean isIn(String text, String pattern)
	{
		String[] patternString = pattern.split(",");
		for (int a = 0; a < patternString.length; ++a)
		{
			if (("" + text).equalsIgnoreCase(patternString[a].trim()))
				return true;
		}
		return false;
	}

	/**
	 * Checks whether data1 is on same day as date2
	 * 
	 * @param date1
	 * @param date2
	 * @return boolean
	 */
	public static boolean isSameDay(Date date1, Date date2)
	{
		if (date1 == null || date2 == null)
		{
			throw new IllegalArgumentException("The dates must not be null");
		}
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(date1);
		Calendar cal2 = Calendar.getInstance();
		cal2.setTime(date2);
		return isSameDay(cal1, cal2);
	}

	/**
	 * <p>
	 * Checks if a date is today.
	 * </p>
	 * 
	 * @param date the date, not altered, not null.
	 * @return true if the date is today.
	 * @throws IllegalArgumentException if the date is <code>null</code>
	 */
	public static boolean isToday(Date date)
	{
		return isSameDay(date, Calendar.getInstance().getTime());
	}

	/**
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public static String[] getTexts(File file) throws IOException
	{
		BufferedReader br = new BufferedReader(new FileReader(file));
		String line = br.readLine();
		ArrayList textList = new ArrayList();
		while (line != null)
		{
			if (!line.startsWith("#"))
				textList.add(line);
			line = br.readLine();
		}
		return (String[]) textList.toArray(new String[] {});
	}

	public static Properties getAsProperties(String paras)
	{
		Properties props = new Properties();
		try
		{
			paras = URLDecoder.decode(paras, dfltEncName);
		}
		catch (UnsupportedEncodingException e)
		{
			// The system should always have the platform default
		}
		StringTokenizer st = new StringTokenizer(paras, "?&");
		while (st.hasMoreTokens())
		{
			String para = st.nextToken();
			int index = para.indexOf("=");
			if (index > -1)
			{
				String key = para.substring(0, index);
				String value = para.substring(index + 1);
				props.put(key, value);
			}
		}
		return props;
	}

	private static String incrementKey(Map map, String key)
	{
		String newkey = key;
		int i = 0;
		while (map.containsKey(newkey))
		{
			newkey = key + "[#" + (i++) + "]";
		}
		return newkey;
	}

	public static TreeMap getTextsAsMap(String filename) throws IOException
	{
		TreeMap linkMap = new TreeMap();
		if (filename != null)
		{
			BufferedReader br = new BufferedReader(new FileReader(new File(filename)));
			String line = br.readLine();

			int counter = 0;
			while (line != null)
			{
				line = line.trim();
				if (!line.startsWith("#"))
				{
					String key = "";
					int star = line.indexOf("*");
					if (star==-1)
						star = line.indexOf("\t");
					if (star > -1)
					{
						key = line.substring(0, star);
						key = incrementKey(linkMap, key);
						line = line.substring(star + 1);
					}
					else
					{
						key = "#" + counter;
					}
					linkMap.put(key, line);
				}
				line = br.readLine();
				counter++;
			}
			br.close();
		}
		return linkMap;
	}

	public static String embed(String text, String envelope, boolean doEmbed)
	{
		if (doEmbed)
		{
			StringBuffer sb = new StringBuffer(envelope);
			sb.append(text);
			if (envelope.startsWith("<"))
			{
				sb.append("</" + envelope.substring(1));
			}
			else
			{
				sb.append(envelope);
			}
			return sb.toString();
		}
		else
			return text;
	}

	public static String listToString(Iterator<?> it, String lnSep)
	{
		String res = "";
		while (it.hasNext())
		{
			res += it.next();
			if (it.hasNext())
				res += lnSep;
		}
		return res;
	}

	public static Object getKeyForValue(HashMap<Object, Object> hm, Object value)
	{
		Iterator<Entry<Object, Object>> it = hm.entrySet().iterator();
		while (it.hasNext())
		{
			Entry<Object, Object> entry = it.next();
			if (entry.getValue() == null)
			{
				if (value == null)
					return entry.getKey();
			}
			else if (entry.getValue().equals(value))
			{
				return entry.getKey();
			}
		}
		return null;
	}

	public static Object getKeyForValue2(HashMap<String, ArrayList<Object>> hm, Object value)
	{
		Iterator<Entry<String, ArrayList<Object>>> it = hm.entrySet().iterator();
		while (it.hasNext())
		{
			Entry<String, ArrayList<Object>> entry = it.next();
			if (entry.getValue() == null)
			{
				if (value == null)
					return entry.getKey();
			}
			else if (entry.getValue().equals(value))
			{
				return entry.getKey();
			}
			else if (entry.getValue().contains(value))
			{
				return entry.getKey();
			}
		}
		return null;
	}

	public static String[] split(String in, String delim)
	{
		StringTokenizer st = new StringTokenizer(in, delim);
		ArrayList al = new ArrayList();
		while (st.hasMoreTokens())
		{
			String tok = st.nextToken();
			al.add(tok);
		}
		return (String[]) al.toArray(new String[] {});
	}

	public static int countCharacter(String in, char character)
	{
		int counter = -1;
		if (in != null)
		{
			counter = 0;
			for (int a = 0; a < in.length(); ++a)
			{
				if (in.charAt(a) == character)
				{
					counter++;
				}
			}
		}
		return counter;
	}

	public static int countString(String in, String pattern)
	{
		String in2 = in.replaceAll(pattern, "" + (char) 1);
		return countCharacter(in2, (char) 1);
	}

	public static String replace(String in, String pattern, String replacement)
	{
		String repl = in;
		int index = repl.indexOf(pattern);
		while (index > -1)
		{
			repl = repl.substring(0, index) + replacement + repl.substring(index + pattern.length());
			index = repl.indexOf(pattern, index + pattern.length());
		}
		return repl;
	}

	public static void copyFile(File sourceFile, File destFile) throws IOException
	{
		if (!destFile.exists())
		{
			destFile.createNewFile();
		}

		FileChannel source = null;
		FileChannel destination = null;
		try
		{
			source = new FileInputStream(sourceFile).getChannel();
			destination = new FileOutputStream(destFile).getChannel();
			destination.transferFrom(source, 0, source.size());
		}
		finally
		{
			if (source != null)
			{
				source.close();
			}
			if (destination != null)
			{
				destination.close();
			}
		}
	}

	public static String replaceTagsContent(String tagPostFix, String content, String newValue)
	{
		tagPostFix += ">";
		String old = getBetween(content, tagPostFix, "</");
		if (old != null)
			return content.replace(tagPostFix + old, tagPostFix + newValue);
		else
			return content;
	}

	public static String replaceAllTagsContent(String tagPostFix, String content, String newValue)
	{
		tagPostFix += ">";
		String[] old = getAllBetween(content, tagPostFix, "</");
		String repl = content;
		for (int a = 0; a < old.length; ++a)
		{
			repl = repl.replace(tagPostFix + old[a], tagPostFix + newValue);
		}
		return repl;
	}

	/**
	 * Left oriented
	 * 
	 * @param in e.g. Dear Sir
	 * @param text1 e.g. e
	 * @param text2 e.g. r
	 * @return e.g. a
	 */
	public static String getBetween(String in, String text1, String text2)
	{
		if (in != null)
			if (in.indexOf(text1) != -1)
			{
				int index1 = in.indexOf(text1) + text1.length();
				int index2 = in.indexOf(text2, index1);
				if (index2 == -1)
				{
					index2 = in.length();
				}
				return in.substring(index1, index2);
			}
		return null;
	}

	/**
	 * Right oriented
	 * 
	 * @param in e.g. Dear Sir
	 * @param text1 e.g. e
	 * @param text2 e.g. r
	 * @return e.g. a
	 */
	public static String getBetweenR(String in, String text1, String text2)
	{
		int index2 = in.indexOf(text2);
		if (index2 != -1)
		{
			String before = in.substring(0, index2);
			int index1 = before.lastIndexOf(text1);
			if (index1 != -1)
			{
				return in.substring(index1 + text1.length(), index2);
			}
		}
		return null;
	}

	public static String[] getAllBetween(String in, String text1, String text2)
	{
		ArrayList<String> al = new ArrayList<String>();
		int start = 0;
		while (in.indexOf(text1, start) != -1)
		{
			int index1 = in.indexOf(text1, start) + text1.length();
			int index2 = in.indexOf(text2, index1);
			if (index2 == -1)
			{
				index2 = in.length();
			}
			al.add(in.substring(index1, index2));
			start = index2 + text2.length() + 1;
		}
		return al.toArray(new String[] {});
	}

	/**
	 * 
	 * @param in e.g. 'Dear Sir'
	 * @param text1 e.g. 'e'
	 * @param text2 e.g. 'r'
	 * @return e.g. ear
	 */
	public static String getFromTo(String in, String text1, String text2)
	{
		if (in.indexOf(text1) != -1)
		{
			int index1 = in.indexOf(text1);
			int index2 = in.indexOf(text2, index1 + text1.length()) + text2.length();
			return in.substring(index1, index2);
		}
		return null;
	}

	public static TreeMap<String, String> getMapFromFile(String file) throws IOException
	{
		TreeMap<String, String> map = new TreeMap<String, String>();
		BufferedReader br = new BufferedReader(new FileReader(file));
		String line = br.readLine();
		while (line != null)
		{
			if (!line.startsWith("#"))
			{
				int sep = line.lastIndexOf("=");
				map.put(line.substring(0, sep), line.substring(sep + 1));
			}
			line = br.readLine();
		}
		return map;
	}

	/**
	 * Return starttime in xls format
	 * 
	 * @return
	 */
	public static String getDateInExcelFormat(long millis)
	{
		SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
		return sdf.format(new Date(millis));
	}

	public static String getDate()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HHmmss");
		return sdf.format(new Date());
	}

	public static String getDay()
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd");
		return sdf.format(new Date());
	}

	public static ArrayList<File> extract(String parentPath, String zipFilename)
	{
		final int BUFFER = 2048;
		ArrayList<File> files = new ArrayList<File>();
		try
		{
			BufferedOutputStream dest = null;
			FileInputStream fis = new FileInputStream(zipFilename);
			ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
			ZipEntry entry;
			while ((entry = zis.getNextEntry()) != null)
			{
				int count;
				byte data[] = new byte[BUFFER];
				// write the files to the disk
				String filename = entry.getName();
				long lm = entry.getTime();
				File file = checkPath(parentPath, filename);
				files.add(file);
				System.err.println("Extracting " + new File(filename).getName() + " to " + file);
				FileOutputStream fos = new FileOutputStream(file);
				dest = new BufferedOutputStream(fos, BUFFER);
				while ((count = zis.read(data, 0, BUFFER)) != -1)
				{
					dest.write(data, 0, count);
				}
				dest.flush();
				dest.close();
				file.setLastModified(lm);
			}
			zis.close();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return files;
	}

	public static File checkPath(String folderName, String filename)
	{
		File file = new File(folderName, filename).getAbsoluteFile();
		checkFile(file);
		return file;
	}

	private static void checkFile(File file)
	{
		File parent = file.getParentFile();
		if (parent != null)
		{
			if (parent.exists())
			{
				return;
			}
			else
			{
				checkFile(parent);
				parent.mkdir();
			}
		}
	}

	public static ByteArrayOutputStream getBytesArrayOutputStream(File file) throws IOException
	{
		return getBytesArrayOutputStream(new FileInputStream(file));
	}

	public static ByteArrayOutputStream getBytesArrayOutputStream(InputStream is) throws IOException
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		byte[] buffer = new byte[2048];
		int len = -1;
		while ((len = is.read(buffer)) != -1)
		{
			baos.write(buffer, 0, len);
		}
		baos.close();
		return baos;
	}

	public static String getString(File file) throws IOException
	{
		return getString(new FileInputStream(file));
	}

	public static String getString(InputStream is) throws IOException
	{
		InputStreamReader br = new InputStreamReader((is));// , ("UTF-8"));// ,
		// Charset.forName("UTF-8")));
		StringBuilder ret = new StringBuilder("");
		char[] buffer = new char[2048];
		int len = -1;
		len = br.read(buffer);
		while (len != -1)
		{
			ret.append(buffer, 0, len);
			len = br.read(buffer);
		}
		is.close();
		return ret.toString();
	}

	public static File setString(File file, String str) throws IOException
	{
		return setString(file, str, false);
	}

	public static File setString(File file, String str, boolean append) throws IOException
	{
		OutputStreamWriter bw = (new OutputStreamWriter(new FileOutputStream(file, append), ("UTF-8")));
		bw.write(str);
		bw.close();
		return file;
	}

	public static File extract(InputStream src, File tar) throws IOException
	{
		GZIPInputStream gzis = new GZIPInputStream((src));
		FileOutputStream fos = new FileOutputStream(tar);
		copy(fos, gzis, 2048);
		return tar;
	}

	public static File extract(File src, File tar) throws IOException
	{
		return extract(new FileInputStream(src), tar);
	}

	public static File compress(InputStream src, File tar) throws IOException
	{
		GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(tar));
		copy(gzos, src, 2048);
		return tar;
	}

	public static File compress(String data, File tar) throws IOException
	{
		return compress(data.getBytes("UTF-8"), tar);
	}

	public static File compress(byte[] bytes, File tar) throws IOException
	{
		GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(tar));
		gzos.write(bytes);
		return tar;
	}

	public static void copy(OutputStream out, InputStream in, int bufferSize) throws IOException
	{
		byte[] buffer = new byte[bufferSize];
		for (int len; (len = in.read(buffer)) != -1;)
		{
			out.write(buffer, 0, len);
		}
		in.close();
		out.close();
	}

	public static MemoryData getMemoryState()
	{
		return new MemoryData();
	}

	public static class MemoryData implements Comparable, Serializable
	{
		private static final long serialVersionUID = 1L;
		public long totalMemory = Runtime.getRuntime().totalMemory();
		public long freeMemory = Runtime.getRuntime().freeMemory();

		public String toString()
		{
			return toStringFull();
		}

		public String toStringExplained()
		{
			long usedMemory = totalMemory - freeMemory;
			String mem = "";
			mem += usedMemory / 1024 / 1024 + "MB used /" + freeMemory / 1024 / 1024 + "MB free /" + totalMemory / 1024 / 1024 + "MB alloc";
			return mem;
		}

		public String toStringDetailed()
		{
			long usedMemory = totalMemory - freeMemory;
			String mem = "";
			mem += "(" + usedMemory + "/" + freeMemory + "/" + totalMemory + ")";
			return mem;
		}

		public String toStringFull()
		{
			String mem = "";
			mem += toStringExplained();
			mem += toStringDetailed();
			return mem;
		}

		public int compareTo(Object o)
		{
			int ret = 0;
			if (o instanceof MemoryData)
			{
				ret = new Long(totalMemory).compareTo(new Long(((MemoryData) o).totalMemory));
			}
			return ret;
		}

		public boolean equals(Object o)
		{
			if (o instanceof MemoryData)
			{
				return totalMemory == ((MemoryData) o).totalMemory;
			}

			return false;
		}

		public int hashCode()
		{
			return (int) (totalMemory / 1024);
		}
	}

}
