package de.j4ee.util;

import java.io.PrintWriter;
import java.io.StringWriter;

import sun.reflect.Reflection;

public class Tracer
{

	/**
	 * This method prints throwables
	 * @param t
	 */
	public static void printThrowable(Throwable t)
	{
		t.printStackTrace();
	}

	public static String getPointOfOccurence(int level)
	{
		Exception ex = new Exception();
		try
		{
			StackTraceElement stes[] = ex.getStackTrace();
			StackTraceElement ste = stes[level + 1];// Add this method-call step
			return ste.getMethodName() + "@" + ste.getClassName() + "(" + ste.getLineNumber() + ")";
		}
		catch (Throwable e)
		{
			return getStringException(ex);
		}
	}

	public static String getException(Throwable ex)
	{
		try
		{
			StringBuffer sb = new StringBuffer(ex.toString() + "\n");
			StackTraceElement[] ste = ex.getStackTrace();
			for (int a = 0; a < ste.length; ++a)
			{
				sb.append("\t\t at " + ste[a] + "\n");
			}
			if (ex.getCause() != null)
			{
				sb.append(getException(ex.getCause()));
			}
			return sb.toString();
		}
		catch (Throwable e)
		{
			return getStringException(ex);
		}
	}

	private static String getStringException(Throwable t)
	{
		StringWriter sw=new StringWriter();
		t.printStackTrace(new PrintWriter(sw));
		String string = sw.toString();
		return string;
	}

	public static void initCause(Throwable newExeption, Throwable cause)
	{
		try
		{
			newExeption.initCause(cause);
			Tracer.printThrowable(cause);
		}
		catch (Throwable e)
		{
			Tracer.printThrowable(cause);
		}
	}
	
	public static void trace(String text, boolean trace)
	{
		if (trace)
		{
			String source=Reflection.getCallerClass(2).getSimpleName();
			System.err.println("[Trace@"+source+"]:"+text);
		}
	}

}
