package de.j4ee.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
/**
 * 
 * @author Kristian Martin
 * 
 */
public class Parser
{

	public static String wildcardToRegex(String patternIn)
	{
		String regex = patternIn;// Pattern.quote(patternIn);
		regex = regex.replace("*", ".*");
		regex = regex.replace("?", ".");
		return regex;
	}

	/**
	 * 
	 * @param expr
	 * @param in
	 * @param index Starts with 0
	 * @return
	 */
	public String getRexEx(String expr, String in, int index)
	{
		Matcher eid = Pattern.compile(expr).matcher(in);
		if (eid.find())
		{
			int counter = 0;
			while (counter < index && eid.find())
			{
				counter++;
			}
			if (counter == index)
				return in.substring(eid.start(), eid.end());
		}
		return null;

	}

	public List<String> find(String text, String from, String to)
	{
		ArrayList<String> results = new ArrayList<String>();
		if (text != null)
		{
			int start = text.indexOf(from);
			int stop = text.indexOf(to, start + from.length());
			while (start > -1 && stop > -1)
			{
				results.add(text.substring(start + from.length(), stop));
				start = text.indexOf(from, stop + 1);
				stop = text.indexOf(to, start + from.length());
			}
		}
		return results;
	}

	public String get(String text, String from, String to)
	{
		List<String> ret = find(text, from, to);
		if (ret.size() > 0)
		{
			return "" + ret.get(0);
		}
		return null;
	}

	public String get(String text, String from, String to, int index)
	{
		List<String> ret = find(text, from, to);
		if (index == -1 && ret.size()>0)
		{
			return "" + ret.get(ret.size()-1);
		}
		else if (ret.size() > index)
		{
			return "" + ret.get(index);
		}
		return null;
	}

	public String readFile(String filename)
	{
		String content = "";
		if (filename != null)
		{
			try
			{
				BufferedReader br = new BufferedReader(new FileReader(new File(filename)));
				String line = br.readLine();
				while (line != null)
				{
					content += line.trim();
					line = br.readLine();
				}
				br.close();
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
		return content;
	}

	public static void main(String[] args)
	{
		String in = "Das ist Meier";
		String regex = wildcardToRegex("? ist ?");
		System.err.println(new Parser().getRexEx(regex, in, 0));
	}

}
