/**
 * 
 */
package de.j4ee.util;

import java.io.Serializable;

/**
 * @author Kristian Martin
 *
 *	There is no Warranty
 */
public class MemoryData implements Comparable, Serializable
{
	private static final long serialVersionUID = 1L;
	public long totalMemory = Runtime.getRuntime().totalMemory();
	public long freeMemory = Runtime.getRuntime().freeMemory();

	public String toString()
	{
		return toStringFull();
	}

	public String toStringExplained()
	{
		long usedMemory = totalMemory - freeMemory;
		String mem = "";
		mem += usedMemory / 1024 / 1024 + "MB used /" + freeMemory / 1024 / 1024 + "MB free /" + totalMemory / 1024 / 1024
				+ "MB alloc";
		return mem;
	}

	public String toStringDetailed()
	{
		long usedMemory = totalMemory - freeMemory;
		String mem = "";
		mem += "(" + usedMemory + "/" + freeMemory + "/" + totalMemory + ")";
		return mem;
	}

	public String toStringFull()
	{
		String mem = "";
		mem += toStringExplained();
		mem += toStringDetailed();
		return mem;
	}

	public int compareTo(Object o)
	{
		int ret = 0;
		if (o instanceof MemoryData)
		{
			ret = new Long(totalMemory).compareTo(new Long(((MemoryData) o).totalMemory));
		}
		return ret;
	}

	public boolean equals(Object o)
	{
		if (o instanceof MemoryData)
		{
			return totalMemory == ((MemoryData) o).totalMemory;
		}

		return false;
	}

	public int hashCode()
	{
		return (int) (totalMemory / 1024);
	}
}