package de.j4ee.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import de.j4ee.util.config.Condition;
import de.j4ee.util.fileWrapper.ClipboardFile;
import de.j4ee.util.fileWrapper.PseudoClipboardFile;
import de.j4ee.util.fileWrapper.URLFile;
public class CommonUtil
{
	public final static String lineSep=System.getProperty("line.separator");
	
	public static void setRelativeLocation(Component parent, Window rel)
	{
		if (!Condition.getInstance().useBackwardMode())
		{
			rel.setLocationRelativeTo(parent);
		}
		else
		{
			Dimension paneSize = rel.getSize();
			Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
			rel.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
		}
	}
	
	public static OutputStream getOutputStream(File file) throws FileNotFoundException
	{
		if (file instanceof ClipboardFile)
		{
			return ((ClipboardFile) file).getOutputStream();
		}
		else if (file instanceof PseudoClipboardFile)
		{
			return ((PseudoClipboardFile) file).getOutputStream();
		}
		else
		{
			return new FileOutputStream(file);
		}
	}

	public static InputStream getInputStream(File file) throws IOException
	{
		if (file instanceof URLFile)
		{
			return ((URLFile) file).getInputStream();
		}
		else if (file instanceof ClipboardFile)
		{
			return ((ClipboardFile) file).getInputStream();
		}
		else if (file instanceof PseudoClipboardFile)
		{
			return ((PseudoClipboardFile) file).getInputStream();
		}
		else
		{
			return new FileInputStream(file);
		}
	}



	public static String quote(String text)
	{
		return "\"" + text.replace('"', '\'') + "\"";
	}

	public static List getList(String text, String delims)
	{
		List retList = new LinkedList();
		if (text != null)
		{
			StringTokenizer st = new StringTokenizer(text, delims);
			while (st.hasMoreTokens())
			{
				String t = st.nextToken().trim();
				if (t.length() > 0)
				{
					if (!retList.contains(t))
					{
						retList.add(t);
					}
				}
			}
		}
		return retList;
	}

	public static String readInputStream(InputStream is) throws IOException
	{
		StringBuffer sb = new StringBuffer();
		byte[] buffer = new byte[100];
		int l = is.read(buffer);
		while (l != -1)
		{
			sb.append(new String(buffer, 0, l));
			l = -1;
			if (is.available() > 0)
			{
				l = is.read(buffer);
			}
		}
		return sb.toString();
	}

	public static StringBuffer getIterableAsStringlist(Collection collection)
	{
		StringBuffer sb = new StringBuffer();
		Iterator it = collection.iterator();
		while (it.hasNext())
		{
			sb.append(it.next()).append("\n");
		}
		return sb;
	}

	public static StringBuffer getIterableAsString(Collection collection)
	{
		return getIterableAsString(collection, ',');
	}

	public static StringBuffer getIterableAsString(Collection collection, char delim)
	{
		StringBuffer sb = new StringBuffer();
		Iterator it = collection.iterator();
		while (it.hasNext())
		{
			sb.append(it.next());
			if (it.hasNext())
			{
				sb.append(delim);
			}
		}
		return sb;
	}

	public static StringBuffer getMapAsStringlist(Map hm)
	{
		StringBuffer sb = new StringBuffer();
		Iterator it = hm.entrySet().iterator();
		while (it.hasNext())
		{
			Map.Entry entry = (Map.Entry) it.next();
			String key = (String) entry.getKey();
			sb.append(key).append("=").append(entry.getValue());
			if (it.hasNext())
			{
				sb.append("\n");
			}
		}
		return sb;
	}

	public static String findAndReplaceReservedXmlChars(String text)
	{
		text = findAndReplaceReservedXmlChars_(text, "&");
		text = findAndReplaceReservedXmlChars_(text, "<");
		text = findAndReplaceReservedXmlChars_(text, ">");
		text = findAndReplaceReservedXmlChars_(text, "\"");
		text = findAndReplaceReservedXmlChars_(text, "'");
		// text = replaceString(text, String.valueOf((char) 0x03), "ETX",
		// false);
		// text = replaceString(text, String.valueOf((char) 0x13), "LB", false);
		// text = replaceString(text, String.valueOf((char) 0x10), "CR", false);
		return text;
	}

	private static String findAndReplaceReservedXmlChars_(String text, String old)
	{
		return replaceString(text, old, "&#" + old.getBytes()[0] + ";", false);
	}

	public static StringBuffer replaceStringBuffer(StringBuffer text, String old, String neu, boolean recursive)
	{
		boolean fit = true;
		int start = 0;
		int index = -1;
		while (fit)
		{
			index = text.toString().indexOf(old, start);
			if (index > -1)
			{
				text = new StringBuffer(text.substring(0, index)).append(neu).append(text.substring(index + old.length()));
			}
			else
			{
				fit = false;
			}
			if (!recursive)
			{
				start = index + neu.length();
			}
		}
		return text;
	}


	public static int countString(String text, String pattern)
	{
		int count=0;
		boolean fit = true;
		int start = 0;
		int index = -1;
		while (fit)
		{
			index = text.indexOf(pattern, start);
			if (index == -1)
			{
				fit = false;
			}
			else
			{
				count++;
			}
			start = index + pattern.length();
		}
		return count;
	}
	
	public static String replaceString(String text, String old, String neu, boolean recursive)
	{
		boolean fit = true;
		int start = 0;
		int index = -1;
		while (fit)
		{
			index = text.indexOf(old, start);
			if (index > -1)
			{
				text = text.substring(0, index) + neu + text.substring(index + old.length());
			}
			else
			{
				fit = false;
			}
			if (!recursive)
			{
				start = index + neu.length();
			}
		}
		return text;
	}

	public static MouseEvent getMouseEvent(KeyEvent ke, int id)
	{
		return new MouseEvent((Component) ke.getSource(), id, ke.getWhen(), ke.getModifiers(), -1, -1, 1, false);
	}

	public static String getAsByteString(byte[] bytes)
	{
		StringBuffer sb = new StringBuffer();
		for (int a = 0; a < bytes.length; ++a)
		{
			sb.append(bytes[a] + ";");
		}
		return sb.toString();
	}

	public static String getAsByteString(String t)
	{
		return getAsByteString(t.getBytes());
	}

	public static String printAsByteString(byte[] bytes)
	{
		String ret = getAsByteString(bytes);
		return ret;
	}

	public static String printAsByteString(String t)
	{
		if (t!=null)
		return printAsByteString(t.getBytes());
		return null;
	}

	public static String getTimeStamp()
	{
		java.text.DateFormat tf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
		java.util.Calendar calendar = new java.util.GregorianCalendar();
		return (tf.format(calendar.getTime()));
	}

	public static String getExcelTimeStamp(long time)
	{
		SimpleDateFormat sdf=new SimpleDateFormat("dd.MM.yy HH:mm:ss");
		return sdf.format(new Date(time));
	}
	
	/**
	 * Find and returns parent container of given container which parent is of
	 * given type
	 * 
	 * @param obj
	 *            Container to be traversed up
	 * @param type
	 *            Type of class to be found
	 * @return Container that is child of type
	 */
	public static Container findContainerThatIsChildOfType(Container obj, Class type)
	{
		Container container = (Container) obj;
		while (container != null && container.getParent() != null && !(type.isAssignableFrom(container.getParent().getClass())))
		{
			container = (container.getParent());
		}
		return container;
	}

	/**
	 * Runs garbage collection request
	 */
	public static void requestGC()
	{
		System.gc();
		System.runFinalization();
		System.gc();
		System.runFinalization();
	}

	/**
	 * Returns LastModifiedDate of passed Class
	 * @param clazz
	 * @return Lastmodified Timestamp
	 */
	public static String getLM(Class clazz)
	{
		String built = null;
		File file = getFile(clazz);
		if (file != null)
		{
			try
			{
				java.text.DateFormat tf = new java.text.SimpleDateFormat("yyyyMMdd@HHmmss");
				built = tf.format(new Date(file.lastModified()));
			}
			catch (Throwable e)
			{
			}
		}
		return built;
	}
	
	/**
	 * 
	 * Returns binary file of class. In case class is inside jar it will return
	 * the jarfile
	 * 
	 * @param clazz
	 *            class
	 * @return file file
	 */
	public static File getFile(Class clazz)
	{
		File file = null;
		String filename = null;
		try
		{
			Package pack = clazz.getPackage();
			String pS = pack.getName();
			int start = 0;
			int count = 0;
			while (start != -1)
			{
				start = pS.indexOf('.', start + 1);
				count++;
			}
			String className = clazz.getSimpleName();//Name().substring(pS.length() + 1);
			try
			{
				file = new File(new URI(clazz.getResource(className + ".class").toString()));
				filename = file.toString();
				file = new File(filename);
				// test:
				file.lastModified();
			}
			catch (Throwable e)
			{
				try
				{
					String tt = (clazz.getResource(className + ".class").getPath());
					String dd = URLDecoder.decode(tt, "UTF-8");
					file = new File(dd);
					filename = file.toString();
					if (!file.exists())
					{
						for (int a = 0; a < count + 1; ++a)
						{
							file = file.getParentFile();
						}
						filename = file.toString();
						filename = filename.substring(filename.indexOf("file:\\") + 6, filename.length() - 1);
					}
					file = new File(filename);
					if (file.exists())
					{
						// test:
						file.lastModified();
					}
				}
				catch (Throwable t)
				{
					String tt = (clazz.getResource(className + ".class").getPath());
					// This method is required for old versions providing
					// backward compatibility
					String dd = URLDecoder.decode(tt,"UTF-8");
					file = new File(dd);
					filename = file.toString();
					if (!file.exists())
					{
						for (int a = 0; a < count + 1; ++a)
						{
							file = file.getParentFile();
						}
						filename = file.toString();
						filename = filename.substring(filename.indexOf("file:\\") + 6, filename.length() - 1);
					}
					file = new File(filename);
					if (file.exists())
					{
						// test:
						file.lastModified();
					}
				}
			}

		}
		catch (Throwable e)
		{
		}
		return file;
	}

	/**
	 * Extracts parameter passed on a web-query followed of '?'.
	 * @param query e.g.: query?request=command&command=test
	 * @return parameters e.g.: HashMap[]{request=command,command=test};
	 * @throws UnsupportedEncodingException 
	 */
	public static Map getRequestParameter(String query) throws UnsupportedEncodingException
	{
		Properties hm=new Properties();
		int qmIndex=query.indexOf('?');
		if (qmIndex>-1)
		{
		StringTokenizer st=new StringTokenizer(query.substring(qmIndex+1).trim(),"&");
		while (st.hasMoreTokens())
		{
			String token=st.nextToken();
			int eqIndex=token.indexOf('=');
			if (eqIndex>-1)
			{
				hm.put(token.substring(0,eqIndex).trim(),URLDecoder.decode(token.substring(eqIndex+1).trim(), "UTF-8"));
			}
		}}
		return hm;
	}

	/**
	 * Replaces parts in string<br>
	 * This functionality is part of java > 1.3 already
	 * 
	 * @param source
	 * @param pattern
	 * @param replacement
	 * @return resulting string
	 */
	public static String replace(String source, String pattern, String replacement)
	{
		int i = 0;
		int j = 0;
		if (source != null && pattern != null && replacement != null)
		{
			StringBuffer stringbuffer = new StringBuffer();
			while ((j = source.indexOf(pattern, i)) >= 0)
			{
				stringbuffer.append(source.substring(i, j));
				stringbuffer.append(replacement);
				i = j + pattern.length();
			}
			stringbuffer.append(source.substring(i));
			return stringbuffer.toString();
		}
		return source;
	}

	public static File checkPath(String filename)
	{
		File file=new File(filename);
		return checkPath(file.getParent(),file.getName());
	}
	
	public static File checkPath(String folderName, String filename)
	{
		File file = new File(folderName, filename).getAbsoluteFile();
		checkFile(file);
		return file;
	}

	private static void checkFile(File file)
	{
		File parent = file.getParentFile();
		if (parent != null)
		{
			if (parent.exists())
			{
				return;
			}
			else
			{
				checkFile(parent);
				parent.mkdir();
			}
		}
	}
	
}
