package de.j4ee.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;

import de.j4ee.util.logger.LoggerInterface;
import de.j4ee.util.logger.MyLoggerWrapper;

public abstract class AbstractConfig implements Serializable, Cloneable
{
	private static final long serialVersionUID = -834047803212368856L;
	private Properties settings = null;
	private String domain = "";
	protected LoggerInterface logger=null;

	protected AbstractConfig()
	{
	}

	protected static synchronized AbstractConfig initializeInstance(AbstractConfig config, String configFile, String domain, boolean overrideBySysProps)
	{
		config.readSettings(configFile, domain);
		if (overrideBySysProps)
		{
			config.putAllSysProps();
		}
		config.init();
		return config;
	}

	protected void putAllSysProps()
	{
		if (settings != null)
		{
			settings.putAll(System.getProperties());
		}
	}

	protected abstract void init();

	protected String getProperty(String key)
	{
		return settings.getProperty(domain + key);
	}

	protected void readSettings(String configFileName, String domain)
	{
		logger = MyLoggerWrapper.getLogger(getClass());
		this.domain = domain + ".";
		File file = null;
		settings = new Properties();
		InputStream is = null;
		try
		{
			file = new File(configFileName);
			boolean exists = false;
			try
			{
				exists = file.exists();
			}
			catch (Exception e)
			{
				// REMINDER: T-C: Required as if would fail for applet:
				// java.security.AccessControlException: access denied
				// (java.io.FilePermission ora_setting.conf read)
			}
			if (exists)
			{
				is = new FileInputStream(file);
				settings.load(is);
				logger.debug("Configuration found at '" + file.getAbsolutePath() + "'");
			}
			else
			{
				URL configURL = getClass().getResource("/" + configFileName);
				if (configURL != null)
				{
					logger.debug("Configuration found at '" + configURL + "'");
					is = configURL.openStream();
					settings.load(is);
				}
				else
				{
					logger.warn("Configuration '" + file.getName() + "' not found");
				}
			}
		}
		catch (Throwable e)
		{
			Tracer.printThrowable(e);
			try
			{
				logger.error("Error while loading configuration '" + file.getAbsolutePath() + "':" + e);
			}
			catch (Throwable e2)
			{
				logger.error("Error while loading configuration !" + e);
			}
		}
		finally
		{
			if (is != null)
			{
				try
				{
					is.close();
				}
				catch (IOException e)
				{
					logger.debug(e);
				}
			}
		}
	}
}
